/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef NEWFORMDIALOG_H
#define NEWFORMDIALOG_H

#include <QDialog>

class NewFormTree;
class QPushButton;
class QTreeWidget;
class QTreeWidgetItem;

class NewFormDialog : public QDialog
{
    Q_OBJECT
public:
    NewFormDialog(QWidget *parent);
    ~NewFormDialog();

signals:
    void needOpen();
    void itemPicked(const QString &widgetClass);

private slots:
    void handleClass(const QString &strClass);
    void createThisOne();
    void handleDoubleClick(QTreeWidgetItem *item);
    void fixButton(QTreeWidgetItem *item);

private:
    QTreeWidget *mWidgetTree;
    QPushButton *btnCreate;
};

#endif // NEWFORMDIALOG_H
