/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef ABSTRACTFORMEDITOR_H
#define ABSTRACTFORMEDITOR_H

#include "sdk_global.h"

#include <QObject>
#include <QPointer>

class AbstractWidgetBox;
class AbstractPropertyEditor;
class AbstractFormWindowManager;
class AbstractWidgetDataBase;
class AbstractMetaDataBase;
class AbstractWidgetFactory;
class AbstractDnDManager;
class AbstractObjectInspector;
class AbstractPixmapCache;

class QWidget;

class QExtensionManager;

class QT_SDK_EXPORT AbstractFormEditor: public QObject
{
    Q_OBJECT
public:
    AbstractFormEditor(QObject *parent = 0);
    virtual ~AbstractFormEditor();

    QExtensionManager *extensionManager() const;

    QWidget *topLevel() const;
    AbstractWidgetBox *widgetBox() const;
    AbstractPropertyEditor *propertyEditor() const;
    AbstractFormWindowManager *formWindowManager() const;
    AbstractWidgetDataBase *widgetDataBase() const;
    AbstractMetaDataBase *metaDataBase() const;
    AbstractWidgetFactory *widgetFactory() const;
    AbstractPixmapCache *pixmapCache() const;

    AbstractObjectInspector *objectInspector() const;

    void setTopLevel(QWidget *topLevel);
    void setWidgetBox(AbstractWidgetBox *widgetBox);
    void setPropertyEditor(AbstractPropertyEditor *propertyEditor);
    void setObjectInspector(AbstractObjectInspector *objectInspector);

protected:
    void setFormManager(AbstractFormWindowManager *formWindowManager);
    void setMetaDataBase(AbstractMetaDataBase *metaDataBase);
    void setWidgetDataBase(AbstractWidgetDataBase *widgetDataBase);
    void setWidgetFactory(AbstractWidgetFactory *widgetFactory);
    void setExtensionManager(QExtensionManager *extensionManager);
    void setPixmapCache(AbstractPixmapCache *cache);

private:
    QPointer<QWidget> m_topLevel;
    QPointer<AbstractWidgetBox> m_widgetBox;
    QPointer<AbstractPropertyEditor> m_propertyEditor;
    QPointer<AbstractFormWindowManager> m_formWindowManager;
    QPointer<QExtensionManager> m_extensionManager;
    QPointer<AbstractMetaDataBase> m_metaDataBase;
    QPointer<AbstractWidgetDataBase> m_widgetDataBase;
    QPointer<AbstractWidgetFactory> m_widgetFactory;
    QPointer<AbstractObjectInspector> m_objectInspector;
    QPointer<AbstractPixmapCache> m_pixmapCache;

private:
    AbstractFormEditor(const AbstractFormEditor &other);
    void operator = (const AbstractFormEditor &other);
};

#endif // ABSTRACTFORMEDITOR_H
