/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the demonstration applications of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/


#include "introscreen.h"

#include <qdebug.h>
#include <qevent.h>
#include <qfile.h>
#include <qpainter.h>
#include <qtextdocument.h>
#include <qtextdocumentfragment.h>
#include <qabstracttextdocumentlayout.h>

IntroScreen::IntroScreen(QWidget *widget)
    : DemoWidget(widget), mouseDown(false)
{
    QFile textFile(":/res/html/qt4-arthur.html");
    if (!textFile.open(QFile::ReadOnly))
        text = "Unable to load resource file: 'qt4-arthur.html'";
    else
        text = textFile.readAll();

    // Initialize text...
    textDocument = new QTextDocument(this);
    textDocument->setHtml(text);

    textLayout = textDocument->documentLayout();
    textLayout->setPageSize(QSize(400, 400));
}

void IntroScreen::paintEvent(QPaintEvent *)
{
    int w = width(), h = height();

    if (mouseDown)
        --animationStep;

    QPainter p(this);

    fillBackground(&p);

    QRect textRect(100, 0, w-200, h);

    p.setBrush(QColor(255, 255, 255, attributes->alpha ? 191 : 255));
    p.drawRect(textRect.x() - 20, textRect.y(), textRect.width() + 40, textRect.height());

    p.setPen(Qt::NoPen);
    int blockHeight = textLayout->sizeUsed().height();
    int ypos = (-animationStep % blockHeight);

    p.setClipRegion(textRect);

    p.translate(textRect.x(), ypos);

    QAbstractTextDocumentLayout::PaintContext ctx;
    ctx.showCursor = false;
    ctx.palette = palette();

    for ( ; ypos < h; ypos += blockHeight) {
        ctx.rect = QRect(0, -ypos, w-200, h);
        textLayout->draw(&p, ctx);
        p.translate(0, blockHeight);
    }

    QColor grey = palette().color(QPalette::Background);
}

void IntroScreen::mousePressEvent(QMouseEvent *e)
{
    oldMousePoint = e->pos();
    mouseDown = true;
}

void IntroScreen::mouseReleaseEvent(QMouseEvent *)
{
    mouseDown = false;
}

void IntroScreen::mouseMoveEvent(QMouseEvent *e)
{
    animationStep += oldMousePoint.y() - e->y();
    oldMousePoint = e->pos();
    repaint();
}

void IntroScreen::resizeEvent(QResizeEvent *e)
{
    QWidget::resizeEvent(e);
    textLayout->setPageSize(QSize(e->size().width() - 200, e->size().height()));
}
