/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef WIDGETFACTORY_H
#define WIDGETFACTORY_H

#include "formeditor_global.h"
#include "abstractwidgetfactory.h"

#include <pluginmanager.h>

#include <QMap>
#include <QVariant>
#include <QPointer>

class QObject;
class QWidget;
class QLayout;
class AbstractFormEditor;
struct ICustomWidget;

class QT_FORMEDITOR_EXPORT WidgetFactory: public AbstractWidgetFactory
{
public:
    WidgetFactory(AbstractFormEditor *core, QObject *parent = 0);
    ~WidgetFactory();

    virtual QWidget* containerOfWidget(QWidget *widget) const;
    virtual QWidget* widgetOfContainer(QWidget *widget) const;
    
    virtual QWidget *createWidget(const QString &className, QWidget *parentWidget) const;
    virtual QLayout *createLayout(QWidget *widget, QLayout *layout, int type) const;
    virtual void initialize(QObject *object) const;

    virtual AbstractFormEditor *core() const;

    static const char* classNameOf(QObject* o);
    
public slots:
    void loadPlugins();
    
private:
    AbstractFormEditor *m_core;
    QMap<QString, ICustomWidget*> m_customFactory;
};

#endif // WIDGETFACTORY_H
