/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef PALETTEEDITOR_H
#define PALETTEEDITOR_H

#include "propertyeditor_global.h"
#include "ui_paletteeditor.h"
#include <qvariant.h>
#include <qdialog.h>
#include <qmap.h>

class QT_PROPERTYEDITOR_EXPORT PaletteEditor : public QDialog, public Ui::PaletteEditorBase
{
    Q_OBJECT

public:
    PaletteEditor(QWidget *parent = 0, Qt::WFlags f = 0, QMap<int, QString> *smap = 0);
    ~PaletteEditor();

    static QPalette getPalette(bool *ok, const QPalette &pal, QWidget *parent = 0, QMap<int, QString> *snrMap = 0);

protected slots:
    void onChooseBasicColor();
    void onChooseAdvancedColor();
    void onChoosePixmap();
    void paletteSelected(int item);
    void roleSelected(int item);
    void updatePaletteEditor();

protected:
    void buildInactive();
    void buildDisabled();
    void buildEffect(QPalette::ColorGroup cg);

private:
    void copyColorGroup(const QPalette &fpal, QPalette &tpal, QPalette::ColorGroup fcg, QPalette::ColorGroup tcg);
    void setPreviewPalette(const QPalette &pal);
    void cleanUpsnrMap();
    QPalette pal() const;
    void setPal( const QPalette& );

    QPalette::ColorRole roleFromItem(int item);
    QPalette::ColorGroup groupFromItem(int item);
    QPalette editPalette;
    QPalette previewPalette;

    QMap<int, QString> *snrMap;
};

#endif // PALETTEEDITOR_H
