/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#include <qpainter.h>
#include <qstyle.h>
#include <qstyleoption.h>
#include <qcolordialog.h>
#include <qfiledialog.h>
#include <qimageio.h>

#include "stylebutton.h"

StyleButton::StyleButton (QWidget *parent, ButtonType type)
    : QPushButton(parent), btype(type)
{
    connect(this, SIGNAL(clicked()), this, SLOT(onEditor()));
    mBrush = QBrush(Qt::darkGray);
}

const QBrush &StyleButton::brush()
{
    return mBrush;
}

void StyleButton::setBrush(const QBrush &b)
{
    mBrush = b;

    if (btype == PixmapButton)
        mBrush.setColor(Qt::darkGray);

    update();
}

void StyleButton::setButtonType(ButtonType type)
{
    btype = type;
    update();
}

void StyleButton::paintEvent (QPaintEvent *event)
{
    QPushButton::paintEvent(event);

    QStyleOptionButton opt;
    opt.init(this);
    QRect contentRect = style()->subRect(QStyle::SR_PushButtonContents, &opt, this);

    QPainter paint(this);

    if (btype == ColorButton)
        paint.setBrush(QBrush(mBrush.color()));
    else
        paint.setBrush(mBrush);

    paint.drawRect(contentRect.left()+2, contentRect.top()+2, contentRect.width()-5, contentRect.height()-5);
}

QString StyleButton::buildImageFormatList() const
{
    QString filter;
    QString all = tr("All Pixmaps (");
    for (int i=0; i<QImageIO::outputFormats().count(); ++i) {
        QString outputFormat = QImageIO::outputFormats().at(i);
        QString outputExtension;

        if (outputFormat != "JPEG")
            outputExtension = outputFormat.toLower();
        else
            outputExtension = "jpg;*.jpeg";

        filter += tr("%1-Pixmaps (%2)\n").arg(outputFormat).arg("*." + outputExtension);
        all += "*." + outputExtension + ";";
    }

    filter.prepend(all + tr(")\n"));
    filter += tr("All Files (*.*)");

    return filter;
}

bool StyleButton::openPixmap()
{
    QString fileName = QFileDialog::getOpenFileName(this, tr("Open Image"), QString(), buildImageFormatList());

    if (!fileName.isEmpty()) {
        pixFile = fileName;
        return true;
    }

    return false;
}

QString StyleButton::pixmapFileName() const
{
    return pixFile;
}

void StyleButton::onEditor()
{
    if (btype == ColorButton) {
        QColor c = QColorDialog::getColor();
        if (c.isValid()) {
            mBrush.setColor(c);
            emit changed();
        }
    }
    else if(openPixmap()) {
        emit changed();
    }
}
