/****************************************************************************
**
** Copyright (C) 1992-2004 Trolltech AS. All rights reserved.
**
** This file is part of the designer application of the Qt Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef QMAKEINTERFACE_H
#define QMAKEINTERFACE_H

#include <qmap.h>
#include <qstring.h>
#include <qstringlist.h>

class QMakeProject;
class MakefileGenerator;

#ifdef QT_BUILD_QMAKE_LIBRARY
# define QM_QMAKE_EXPORT Q_DECL_EXPORT
#else
# define QM_QMAKE_EXPORT Q_DECL_IMPORT
#endif

class QM_QMAKE_EXPORT QMakeInterface
{
    QString profile;
    mutable MakefileGenerator *mkfile;
    mutable QMap<QString, MakefileGenerator *> build_mkfile;
    QMakeProject *getBuildStyle(const QString &buildStyle) const;

public:
    QMakeInterface(bool findFile = true, int argc=0, char **argv=0);
    QMakeInterface(const QString &file, int argc=0, char **argv=0);
    ~QMakeInterface();

    QStringList buildStyles() const;

    QStringList compileFlags(const QString &buildStyle = QString::null, bool cplusplus=true) const;
    QStringList defines(const QString &buildStyle = QString::null) const;
    QStringList linkFlags(const QString &buildStyle = QString::null) const;
    QStringList libraries(const QString &buildStyle = QString::null) const;

    bool addVariable(const QString &);
    inline bool addVariable(const QString &var, const QString &val) 
        { return addVariable(var + " += " + val); }
    inline bool setVariable(const QString &var, const QString &val) 
        { return addVariable(var + " = " + val); }
    inline bool setConfig(const QString &config) 
        { return addVariable("CONFIG", config); }
    inline bool setQtConfig(const QString &qt) 
        { return addVariable("QT", qt); }
};

#endif // QMAKEINTERFACE_H
