path=get_absolute_file_path('specfun.tst');
function r=testresult()
  eps=1d-10;
  if or(isnan(real(y))<>isnan(real(yref)))  then r=%t,return,end;
  if or(isnan(imag(y))<>isnan(imag(yref)))  then r=%t,return,end;
  if or(size(y)<>size(yref)) then r=%t,return,end;
  if yref==[] then r=%f,return,end;
  k=find(abs(yref)==0);
  r=or(abs(y(k)-yref(k))>eps);
  k=find(abs(yref)<>0);
  r=r|or(max(abs(y(k)-yref(k))./abs(yref(k)))>eps);
endfunction
ieee(1)
// ------------------------------ besseli(alpha,x)------------------------------

//test of numerical precision reference computed by maple
exec(path+'besseli_ref.sce',-1)
besselI=besseli(alpha',x);
if norm((besselI-besselI_ref)./abs(besselI_ref),1)>1d6*%eps then pause,end


alpha=[];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[1];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[1];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[1.00000000000000244];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.999999900000007491];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[1.26606587775200818];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.465759607593640379];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[4.8807925858650254 11.3019219521363308 27.2398718236044566];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.243000354161825416 0.207001921223986723 0.183540812609328363];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[222.658799873011844 621.944087256767148];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.15041465295234574 0.13985490269028536];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[ 4.8807925858650254
11.3019219521363308
27.2398718236044566];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.243000354161825416
0.207001921223986723
0.183540812609328363];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[222.658799873011844
621.944087256767148];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.15041465295234574
0.13985490269028536];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[222.619934807221995-4.13558800345596822*%i 621.83359839173761+11.6724388635437393*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.150388398093404263-0.00279375005456099917*%i 0.139830057354854626+0.00262475009388627757*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[5.00000000000000904e-08];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[4.99999950000002575e-08];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[0.565159103992485035];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.207910415349708472];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[3.95337021740261063 9.75946515370444878 24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.178750839502435338 0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-206.791670046225448 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[3.95337021740261063
9.75946515370444878
24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865
0.178750839502435338
0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-206.791670046225448
 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735
 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-206.754860873488298+3.88638968263160223*%i 583.551791140428804+11.0485508359642992*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139670925479849994+0.00262540692613094304*%i 0.131221729793522368+0.00248445806253726892*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[0 0 0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0 0 0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[5.00000000000000904e-08 1.25000000000000237e-15 2.08333333333333559e-23];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[4.99999950000002575e-08 1.24999987500000653e-15 2.08333312500000894e-23];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[0.565159103992485035 0.135747669767038337 0.0221684249243319018];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.207910415349708472 0.0499387768942235674 0.00815530777281429572];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[3.95337021740261063 6.42218937528410549 10.3311501691511403];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.117626501472769041 0.0696107422793332264];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[ 3.9533702174026093 2.2452124409299512 0.959753629496007843
9.75946515370445056 6.42218937528410549 3.33727577842034417
24.3356421424505349 17.5056149666242433 10.3311501691511403];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.111782545296958177 0.0477833195680233067
0.178750839502435338 0.117626501472769041 0.0611243380296663044
0.163972266944542394 0.117951905831511425 0.0696107422793332264];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-206.791670046225448 166.003547805552813 -115.830821933593796
 583.657019840486896 482.978130151889332 353.667434053872967];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735 0.112141833362395943 -0.0782482115787162397
 0.131245392289731255 0.10860599976415887 0.0795282495448936949];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[0 0 0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0 0 0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[1.57275203335609045e-09 3.57443643944565263e-17 5.58505693663381842e-25];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[1.57275187608089216e-09 3.57443608200202085e-17 5.58505637812814222e-25];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[0.441739185636620402 0.0970124431622260697 0.0148844357228258926];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.162506764755527944 0.0356888833771960221 0.00547567789586544083];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[3.6230444698358566 5.7349531249690191 9.0956750146270835];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.180380762719529131 0.105039330480750176 0.0612861761694632121];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[ 3.6230444698358566 1.93400965955616022 0.786496969153470338
 9.163110826209099 5.7349531249690191 2.85466238874315748
23.1703721117744479 15.9939739740310927 9.0956750146270835];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.180380762719529131 0.09628867114443182 0.0391573783743615969
0.167828228990296452 0.105039330480750176 0.0522849654614709822
0.156120739238224226 0.107766548941773857 0.0612861761694632121];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-161.961985727353465-117.672270551119524*%i 126.353774591426728+91.8013908146748179*%i -85.8035462475893382-62.3399254025485305*%i 
 567.604978846113681+0*%i 458.189976541412591+0*%i 327.600705419659278+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.109411601466219255-0.07949218152238198*%i 0.0853568741286115373+0.0620153991120368855*%i -0.0579636225393849042-0.0421130368521132753*%i 
 0.127635812783717384+0*%i 0.103031953990436756+0*%i 0.0736666940268219245+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[1
0
0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[1
0
0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[ 1.00000000000000244
5.00000000000000904e-08
1.25000000000000237e-15];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.999999900000007491
4.99999950000002575e-08
1.24999987500000653e-15];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[ 1.26606587775200818
0.565159103992485035
0.135747669767038337];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.465759607593640379
 0.207910415349708472
0.0499387768942235674];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[4.88079258586502363 3.9533702174026093 2.2452124409299512
11.3019219521363308 9.75946515370444878 6.42218937528410549
27.2398718236044566 24.3356421424505349 17.5056149666242433];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.243000354161825444 0.196826713297300893 0.111782545296958191
0.207001921223986723 0.178750839502435338 0.117626501472769041
0.183540812609328363 0.163972266944542394 0.117951905831511425];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[222.658799873011844 -206.791670046225448 166.003547805552813
621.944087256767148 583.657019840486896 482.978130151889332];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.15041465295234574 -0.139695791503316735 0.112141833362395943
0.13985490269028536 0.131245392289731255 0.10860599976415887];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[ 4.8807925858650254
9.75946515370444878
17.5056149666242433];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.243000354161825416
0.178750839502435338
0.117951905831511425];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[222.619934807221995-4.13558800345596822*%i -206.754860873488298+3.88638968263160223*%i 165.972275485088261-3.22602277348055821*%i 
 621.83359839173761+11.6724388635437393*%i 583.551791140428804+11.0485508359642992*%i 482.887220066322243+9.37265623194608821*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.150388398093404263-0.00279375005456099917*%i -0.139670925479849994+0.00262540692613094304*%i 0.112120707697331859-0.0021793034731445015*%i 
0.139830057354854626+0.00262475009388627757*%i 0.131221729793522368+0.00248445806253726892*%i 0.108585557056476545+0.00210760412732592488*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[0];
yref=[0
0
0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0
0
0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[ 0.722522753107872062
3.54177820150917083e-08
8.76677772650785916e-16];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.722522680855600341
3.54177784733136219e-08
8.76677684983011487e-16];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[1];
yref=[ 1.25736065030765642
0.551966122309252905
0.131349760796780485];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.462557133386141961
 0.203056988620695933
0.0483208765999222356];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3 4 5];
yref=[ 4.8796780239824038 3.92148431590033741 2.21306868917017452
11.3010265107873309 9.70283844788389693 6.35257890236654443
27.2385606429501266 24.2259535380059781 17.354371599443688];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.242944863393175281 0.195239207739236365 0.110182202130494566
0.206985520643592436 0.177713685207167515 0.116351541187937002
0.183531977943573288 0.163233190941391326 0.116932836039485649];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[222.212839976181669+13.9804468865899914*%i -205.769686737402196-12.9459313719714064*%i 164.710078202989877+10.3626797634637366*%i 
621.928251907138815+0*%i 582.163410999272628+0*%i 480.545709235886818+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.150113389749855497+0.00944433396642959701*%i -0.139005402150605722-0.00874547862276512863*%i 0.111268044491330098+0.00700039199513633002*%i 
0.139851341837586962+0*%i 0.13090952846623749+0*%i 0.108059027781500699+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3
4
5];
yref=[4.87967802398240469
9.70283844788389693
 17.354371599443688];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.242944863393175253
0.177713685207167543
0.116932836039485649];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 222.43372171741305+9.85068170978665592*%i -205.976447380591082-9.07462886841791594*%i 164.880559993464033+7.1570781308754885*%i 
621.817765198579878+11.6721823301041212*%i 582.058389438462655+11.0240694655973073*%i 480.455154676931897+9.33148596112965834*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.150262603930789579+0.00665451745705368178*%i -0.139145076982263832-0.00613026367110974021*%i 0.111383211551259853+0.00483488379449827435*%i 
0.139826496987075832+0.00262469240789814894*%i 0.130885912548876937+0.00247895300229060943*%i 0.108038665020136204+0.002098346278691713*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[5.00000000000000904e-08];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[4.99999950000002575e-08];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[0.565159103992485035];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.207910415349708472];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[3.95337021740261063 9.75946515370444878 24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.178750839502435338 0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-206.791670046225448 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[3.95337021740261063
9.75946515370444878
24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865
0.178750839502435338
0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-206.791670046225448
 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735
 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-206.754860873488298+3.88638968263160223*%i 583.551791140428804+11.0485508359642992*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139670925479849994+0.00262540692613094304*%i 0.131221729793522368+0.00248445806253726892*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[ 0
-%inf];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0
-%inf];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[5.00000000000000904e-08
 -25231325220.2014771];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[4.99999950000002575e-08
 -25231322697.0690804];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[ 0.565159103992485035
-0.293525326347479576];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.207910415349708472
-0.107981933026376001];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[3.95337021740261063 3.06890365078710392
9.75946515370444878 8.16349962825509046
24.3356421424505349 21.1815571446980186];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.196826713297300865 0.152791715876124834
0.178750839502435338 0.149519711259435889
0.163972266944542394 0.142720209399075454];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-206.791670046225448+0*%i -1.15500082553547188e-14+188.632179137459985*%i 
 583.657019840486896+0*%i 539.257850852657953+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735+0*%i -7.80247843030111646e-18+0.127428351256665628*%i 
 0.131245392289731255+0*%i 0.121261469963673568+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-206.791670046225448
 539.257850852657953];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139695791503316735
 0.121261469963673568];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-206.754860873488298+3.88638968263160223*%i 3.59605973322256212+188.597787293277349*%i 
 583.551791140428804+11.0485508359642992*%i 539.15884497998502+10.3160557682760921*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.139670925479849994+0.00262540692613094304*%i 0.00242927778770507096+0.127405118232369857*%i 
 0.131221729793522368+0.00248445806253726892*%i 0.121239206778007647+0.00231974385669201809*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[0];
yref=[0
0
0
1
0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0
0
0
1
0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[2.08333333333333559e-23
1.25000000000000237e-15
5.00000000000000904e-08
 1.00000000000000244
5.00000000000000904e-08];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[2.08333312500000894e-23
1.24999987500000653e-15
4.99999950000002575e-08
 0.999999900000007491
4.99999950000002575e-08];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[1];
yref=[0.0221684249243319018
 0.135747669767038337
 0.565159103992485035
 1.26606587775200818
 0.565159103992485035];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.00815530777281429572
 0.0499387768942235674
 0.207910415349708472
 0.465759607593640379
 0.207910415349708472];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[3 4 5];
yref=[0.959753629496007843 2.2452124409299512 3.95337021740261063 4.8807925858650254 3.95337021740261063
 3.33727577842034417 6.42218937528410549 9.75946515370444878 11.3019219521363308 9.75946515370444878
 10.3311501691511403 17.5056149666242433 24.3356421424505349 27.2398718236044566 24.3356421424505349];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.0477833195680233067 0.111782545296958191 0.196826713297300865 0.243000354161825416 0.196826713297300865
0.0611243380296663044 0.117626501472769041 0.178750839502435338 0.207001921223986723 0.178750839502435338
0.0696107422793332264 0.117951905831511425 0.163972266944542394 0.183540812609328363 0.163972266944542394];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-115.830821933593796 166.003547805552813 -206.791670046225448 222.658799873011844 -206.791670046225448
 353.667434053872967 482.978130151889332 583.657019840486896 621.944087256767148 583.657019840486896];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.0782482115787162397 0.112141833362395943 -0.139695791503316735 0.15041465295234574 -0.139695791503316735
 0.0795282495448936949 0.10860599976415887 0.131245392289731255 0.13985490269028536 0.131245392289731255];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-115.806987973557767+2.36787822565576178*%i 165.972275485088261-3.22602277348055821*%i -206.754860873488298+3.88638968263160223*%i 222.619934807221995-4.13558800345596822*%i -206.754860873488298+3.88638968263160223*%i 
 353.59617287966239+7.13289457851560726*%i 482.887220066322243+9.37265623194608821*%i 583.551791140428804+11.0485508359642992*%i 621.83359839173761+11.6724388635437393*%i 583.551791140428804+11.0485508359642992*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.0782321108145454941+0.00159959355636766533*%i 0.112120707697331859-0.0021793034731445015*%i -0.139670925479849994+0.00262540692613094304*%i 0.150388398093404263-0.00279375005456099917*%i -0.139670925479849994+0.00262540692613094304*%i 
 0.0795122252353311354+0.00160395491752061796*%i 0.108585557056476545+0.00210760412732592488*%i 0.131221729793522368+0.00248445806253726892*%i 0.139830057354854626+0.00262475009388627757*%i 0.131221729793522368+0.00248445806253726892*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
 0
 0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
 0
 0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ -716418914.617634058
 119.4031524362738
8.52879660259097461e-06
2.50846958899735057e-13];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ -716418842.975746155
 119.40314049595915
 8.5287957497113638e-06
2.50846933815040007e-13];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[-0.00591345243084812067
 1.31287485767574874
 0.781811462174600069
 0.218338810631307279];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.00217543757565433205
 0.482979668969791387
 0.287612363806220073
 0.0803223596410826829];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[3.42784262863483091 4.79637514536136766 4.38711765770707274 2.74905357176475196
8.83635341206673885 11.1547232979699871 10.5095619067623254 7.47637663060326574
22.5339420651292528 26.9640105739216374 25.769623334000169 19.748516040401924];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.170662235306120791 0.238797457280029851 0.218421726762125123 0.136867318124372278
0.161843458188648509 0.204305883829368262 0.192489340763055378 0.136934614562300605
0.151832507315303511 0.181682074129864174 0.173634356210889323 0.133064454390817377];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-115.528257289707909+159.011004637095994*%i 130.005765210304077-178.93758479248288*%i -126.213662649461014+173.718203387166*%i 105.800405250135611-145.621764964810097*%i 
 558.692156624643758+0*%i 618.392276361135487+0*%i 602.863033507589421+0*%i 517.915104109878143+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.0780438174297686527+0.107418099314886509*%i 0.0878239353983073789-0.120879276866858537*%i -0.0852622230789458618+0.117353382345041141*%i 0.0714722761776889204-0.0983731487458936044*%i 
 0.125631610299893642+0*%i 0.139056216478195355+0*%i 0.135564197191194807+0*%i 0.116462183612997774+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-112.495189456596478+161.170833250149371*%i 126.65593794917838-181.323571297084129*%i -122.946019082064936+176.045508070116654*%i 102.984927987823909-147.626271146547765*%i 
 558.590410007747664+10.6379090184516407*%i 618.282271535315886+11.6148531401744517*%i 602.755154351263172+11.3623872324082811*%i 517.819139778511499+9.96031986752753085*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-0.0759948625007086653+0.108877147290777257*%i 0.0855609971932155405-0.122491103267805976*%i -0.083054803145657094+0.118925566900064547*%i 0.0695703121163207677-0.099727270396773135*%i 
 0.125608730810407965+0.00239211813583725934*%i 0.139031479987366591+0.00261180094636132183*%i 0.135539938693977013+0.00255502961323555641*%i 0.116440604370586717+0.00223975047657633264*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
-%inf
 0
 0];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
 0
 0];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 18626891780058524
 -716418914.617634058
 119.4031524362738
8.52879660259097461e-06
2.50846958899735057e-13];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 18626889917369436
 -716418842.975746155
 119.40314049595915
 8.5287957497113638e-06
2.50846933815040007e-13];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ 1.32824983399595298
-0.00591345243084812067
 1.31287485767574874
 0.781811462174600069
 0.218338810631307279];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[ 0.488635806666492145
-0.00217543757565433205
 0.482979668969791387
 0.287612363806220073
 0.0803223596410826829];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[1.82557820054454689 3.42784262863483091 4.79637514536136766 4.38711765770707274 2.74905357176475196
5.41109358012660024 8.83635341206673885 11.1547232979699871 10.5095619067623254 7.47637663060326574
15.2463607000543995 22.5339420651292528 26.9640105739216374 25.769623334000169 19.748516040401924];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.0908901866813934256 0.170662235306120791 0.238797457280029851 0.218421726762125123 0.136867318124372278
0.0991076360067466022 0.161843458188648509 0.204305883829368262 0.192489340763055378 0.136934614562300605
 0.102729170325906158 0.151832507315303511 0.181682074129864174 0.173634356210889323 0.133064454390817377];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[88.8587146687642502-122.303528346393549*%i -115.528257289707909+159.011004637095994*%i 130.005765210304077-178.93758479248288*%i -126.213662649461014+173.718203387166*%i 105.800405250135611-145.621764964810097*%i 
445.463751691602113+0*%i 558.692156624643758+0*%i 618.392276361135487+0*%i 602.863033507589421+0*%i 517.915104109878143+0*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.0600275072726362963-0.0826207757410083593*%i -0.0780438174297686527+0.107418099314886509*%i 0.0878239353983073789-0.120879276866858537*%i -0.0852622230789458618+0.117353382345041141*%i 0.0714722761776889204-0.0983731487458936044*%i 
 0.100170241861561399+0*%i 0.125631610299893642+0*%i 0.139056216478195355+0*%i 0.135564197191194807+0*%i 0.116462183612997774+0*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[86.4321907223755943-124.030462871624579*%i -112.495189456596478+161.170833250149371*%i 126.65593794917838-181.323571297084129*%i -122.946019082064936+176.045508070116654*%i 102.984927987823909-147.626271146547765*%i 
445.378380318171139+8.73384294688499807*%i 558.590410007747664+10.6379090184516407*%i 618.282271535315886+11.6148531401744517*%i 602.755154351263172+11.3623872324082811*%i 517.819139778511499+9.96031986752753085*%i ];
y=besseli(alpha,x);
if testresult() then pause,end
yref=[0.0583882962579143558-0.0837873869750229289*%i -0.0759948625007086653+0.108877147290777257*%i 0.0855609971932155405-0.122491103267805976*%i -0.083054803145657094+0.118925566900064547*%i 0.0695703121163207677-0.099727270396773135*%i 
 0.100151044629256544+0.0019639558932643352*%i 0.125608730810407965+0.00239211813583725934*%i 0.139031479987366591+0.00261180094636132183*%i 0.135539938693977013+0.00255502961323555641*%i 0.116440604370586717+0.00223975047657633264*%i ];
y=besseli(alpha,x,1);
if testresult() then pause,end
// ------------------------------ besselj(alpha,x)------------------------------
//test of numerical precision reference computed by maple
exec(path+'besselj_ref.sce',-1)
besselJ=besselj(alpha',x);
if norm((besselJ-besselJ_ref)./abs(besselJ_ref),1)>1d6*%eps then pause,end



alpha=[];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[1];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[1];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[0.999999999999997446];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.999999999999997446];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[0.765197686557966605];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.765197686557966605];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[-0.260051954901933557 -0.397149809863847236 -0.177596771314338348];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933557 -0.397149809863847236 -0.177596771314338348];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.288216947635014376-1.63247121237385119e-16*%i 0.0691572616569850473+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.288216947635014376-1.63247121237385119e-16*%i 0.0691572616569850473+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[-0.260051954901933557
-0.397149809863847236
-0.177596771314338348];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933557
-0.397149809863847236
-0.177596771314338348];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ 0.288216947635014376-1.63247121237385119e-16*%i 
0.0691572616569850473+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.288216947635014376-1.63247121237385119e-16*%i 
0.0691572616569850473+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.288272330491939344+0.00165156721805876858*%i 0.0691646458471141812-0.00541608716438180676*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.282564155899245439+0.0016188639960181446*%i 0.0677950940990729028-0.00530884145304078969*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[4.99999999999999647e-08];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[4.99999999999999647e-08];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[0.440050585744933553];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.440050585744933553];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[0.339058958525936538 -0.0660433280235490638 -0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.339058958525936538 -0.0660433280235490638 -0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i 0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i 0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[ 0.339058958525936538
-0.0660433280235490638
 -0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.339058958525936538
-0.0660433280235490638
 -0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i 
 0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i 
 0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.0825942221022646084+0.00553845279173677783*%i 0.270840538797723684+0.000738422002625521083*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0809587469274432592+0.0054287840786324832*%i 0.265477536807215531+0.000723800267314064468*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[0 0 0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0 0 0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[4.99999999999999647e-08 1.25e-15 2.08333333333333265e-23];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[4.99999999999999647e-08 1.25e-15 2.08333333333333265e-23];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[0.440050585744933553 0.114903484931900501 0.0195633539826684105];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.440050585744933553 0.114903484931900501 0.0195633539826684105];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[0.339058958525936538 0.36412814585207276 0.364831230613666901];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.339058958525936538 0.36412814585207276 0.364831230613666901];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[ 0.339058958525936649 0.486091260585891194 0.30906272225525161
-0.0660433280235490083 0.364128145852072926 0.430171473875621935
 -0.327579137591465064 0.046565116277752297 0.364831230613666901];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.339058958525936649 0.486091260585891194 0.30906272225525161
-0.0660433280235490083 0.364128145852072926 0.430171473875621935
 -0.327579137591465064 0.046565116277752297 0.364831230613666901];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i -0.265594911883436868+1.66696379225679121e-16*%i 0.228101889059524748-1.43164485837168552e-16*%i 
 0.270786268276835385+0*%i -0.00468434063869093212+0*%i -0.273016906676211979+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0825704304932580041+5.18240040696731648e-17*%i -0.265594911883436868+1.66696379225679121e-16*%i 0.228101889059524748-1.43164485837168552e-16*%i 
 0.270786268276835385+0*%i -0.00468434063869093212+0*%i -0.273016906676211979+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[-0 0 0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0 0 0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[1.57275203335608714e-09 3.57443643944564709e-17 5.585056936633812e-25];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[1.57275203335608714e-09 3.57443643944564709e-17 5.585056936633812e-25];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[0.351883806529722176 0.0829767227596755474 0.0132137736128501541];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.351883806529722176 0.0829767227596755474 0.0132137736128501541];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[0.412044162415463822 0.406986020132752813 0.391959608420348327];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.412044162415463822 0.406986020132752813 0.391959608420348327];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[ 0.412044162415463822 0.463422297657139715 0.267641874148340286
0.0388438196375475928 0.406986020132752813 0.40884080250847965
 -0.2772936869328117 0.130302183508563874 0.391959608420348327];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.412044162415463822 0.463422297657139715 0.267641874148340286
0.0388438196375475928 0.406986020132752813 0.40884080250847965
 -0.2772936869328117 0.130302183508563874 0.391959608420348327];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.000439741362268266983+0.000319490801010906766*%i -0.237705022442928571-0.172702807925255664*%i 0.142834518740318772+0.103775352332019871*%i 
 0.244808700524772438+0*%i -0.0775662890440063368+0*%i -0.285438661452585507+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.000439741362268266983+0.000319490801010906766*%i -0.237705022442928571-0.172702807925255664*%i 0.142834518740318772+0.103775352332019871*%i 
 0.244808700524772438+0*%i -0.0775662890440063368+0*%i -0.285438661452585507+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[1
0
0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[1
0
0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[ 0.999999999999997446
4.99999999999999647e-08
 1.25e-15];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.999999999999997446
4.99999999999999647e-08
 1.25e-15];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[0.765197686557966605
0.440050585744933553
0.114903484931900501];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.765197686557966605
0.440050585744933553
0.114903484931900501];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[-0.260051954901933557 0.339058958525936482 0.486091260585891194
-0.397149809863847236 -0.0660433280235490638 0.36412814585207276
-0.177596771314338348 -0.327579137591465064 0.046565116277752297];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933557 0.339058958525936482 0.486091260585891194
-0.397149809863847236 -0.0660433280235490638 0.36412814585207276
-0.177596771314338348 -0.327579137591465064 0.046565116277752297];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.288216947635014376-1.63247121237385119e-16*%i -0.0825704304932580041+4.67681903786785266e-17*%i -0.265594911883436868+1.5043391839391156e-16*%i 
0.0691572616569850473+0*%i 0.270786268276835385+0*%i -0.00468434063869093212+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.288216947635014376-1.63247121237385119e-16*%i -0.0825704304932580041+4.67681903786785266e-17*%i -0.265594911883436868+1.5043391839391156e-16*%i 
0.0691572616569850473+0*%i 0.270786268276835385+0*%i -0.00468434063869093212+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[ -0.260051954901933557
-0.0660433280235490638
 0.046565116277752297];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.260051954901933557
-0.0660433280235490638
 0.046565116277752297];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.288272330491939344+0.00165156721805876858*%i -0.0825942221022646084+0.00553845279173677263*%i -0.265639789156075279-0.0031069445819979849*%i 
0.0691646458471141812-0.00541608716438180676*%i 0.270840538797723684+0.000738422002625537671*%i -0.00467875023595177783+0.00543836408021845449*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.282564155899245439+0.0016188639960181446*%i -0.0809587469274432592+0.005428784078632478*%i -0.260379768908271136-0.00304542295731204116*%i 
0.0677950940990729028-0.00530884145304078969*%i 0.265477536807215531+0.000723800267314080731*%i -0.00458610477401360205+0.00533067725638924125*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[0];
yref=[ 0
-0
 0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0
-0
 0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[ 0.722522753107868621
3.54177820150916157e-08
8.76677772650784535e-16];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.722522753107868621
3.54177820150916157e-08
8.76677772650784535e-16];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[1];
yref=[0.767624213200681971
0.430847058235354519
0.111303785599441221];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.767624213200681971
0.430847058235354519
0.111303785599441221];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3 4 5];
yref=[-0.248113342531625397 0.347410321977723313 0.4843523614764772
-0.397488017750937228 -0.0555197528009771721 0.369172943822438926
-0.187188738237360264 -0.323527150348924653 0.0551896608949990139];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.248113342531625397 0.347410321977723313 0.4843523614764772
-0.397488017750937228 -0.0555197528009771721 0.369172943822438926
-0.187188738237360264 -0.323527150348924653 0.0551896608949990139];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.289473237714468368+0.0182121124296419773*%i -0.0742460772355384713-0.00467116724416256467*%i -0.268725018870564547-0.0169067451449718964*%i 
0.0774792372615417391+0*%i 0.269158266698860282+0*%i -0.0121122296346756614+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.289473237714468368+0.0182121124296419773*%i -0.0742460772355384713-0.00467116724416256467*%i -0.268725018870564547-0.0169067451449718964*%i 
0.0774792372615417391+0*%i 0.269158266698860282+0*%i -0.0121122296346756614+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3
4
5];
yref=[ -0.24811334253162734
-0.0555197528009771929
 0.0551896608949990139];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.24811334253162734
-0.0555197528009771929
 0.0551896608949990139];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.289436686533186605+0.0196848354538640968*%i -0.0746194938467206886+0.000909756330523188092*%i -0.2685835756459789-0.0198819369191412312*%i 
0.0774883289690142946-0.00537983661590852799*%i 0.269212372909699293+0.0008959309889286695*%i -0.0121080338436329836+0.00544175248673077396*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.283705456146132684+0.0192950495961393617*%i -0.0731419288713772014+0.000891741948211250118*%i -0.263265264520173126-0.0194882481909108424*%i 
0.0759539572521852335-0.00527330871352064186*%i 0.263881610763850749+0.000878190366722298409*%i -0.0118682787098823468+0.00533399856795724152*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[-0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[-4.99999999999999647e-08];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-4.99999999999999647e-08];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[-0.440050585744933553];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.440050585744933553];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[-0.339058958525936538 0.0660433280235490638 0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538 0.0660433280235490638 0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0825704304932580041-5.18240040696731648e-17*%i -0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0825704304932580041-5.18240040696731648e-17*%i -0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[-0.339058958525936538
0.0660433280235490638
 0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538
0.0660433280235490638
 0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 
-0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 
-0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0825942221022646084-0.00553845279173677783*%i -0.270840538797723684-0.000738422002625521083*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0809587469274432592-0.0054287840786324832*%i -0.265477536807215531-0.000723800267314064468*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[ -0
-%inf];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0
-%inf];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[-4.99999999999999647e-08
 -25231325220.2017288];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-4.99999999999999647e-08
 -25231325220.2017288];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[-0.440050585744933553
 -1.10249557516017949];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.440050585744933553
 -1.10249557516017949];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[-0.339058958525936538 0.0870080907208351517
0.0660433280235490638 0.367112032460934101
 0.327579137591465064 0.3219244429611402];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538 0.0870080907208351378
0.0660433280235490638 0.367112032460934101
 0.327579137591465064 0.321924442961140256];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 9.50628464835290288e-16-0.272424375376841277*%i 
-0.270786268276835385+0*%i -0.218249100772301557+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 9.43689570931383059e-16-0.272424375376841332*%i 
-0.270786268276835385+0*%i -0.218249100772301585+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 
-0.218249100772301557+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0825704304932580041-5.18240040696731648e-17*%i 
-0.218249100772301585+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0825942221022646084-0.00553845279173677783*%i -0.00198764870679882157-0.272479284229019014*%i 
-0.270840538797723684-0.000738422002625521083*%i -0.218287028059932248+0.0036388855639192105*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.0809587469274432592-0.0054287840786324832*%i -0.00194829062540415629-0.267083832904858764*%i 
-0.265477536807215531-0.000723800267314064468*%i -0.213964655304420243+0.00356683080206891736*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[0];
yref=[-0
 0
-0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0
 0
-0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[9.99999999999999955e-08];
yref=[-2.08333333333333265e-23
 1.25e-15
-4.99999999999999647e-08];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-2.08333333333333265e-23
 1.25e-15
-4.99999999999999647e-08];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[1];
yref=[-0.0195633539826684105
 0.114903484931900501
 -0.440050585744933553];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0195633539826684105
 0.114903484931900501
 -0.440050585744933553];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[3 4 5];
yref=[ -0.30906272225525161 0.486091260585891194 -0.339058958525936538
-0.430171473875621935 0.36412814585207276 0.0660433280235490638
-0.364831230613666901 0.046565116277752297 0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.30906272225525161 0.486091260585891194 -0.339058958525936538
-0.430171473875621935 0.36412814585207276 0.0660433280235490638
-0.364831230613666901 0.046565116277752297 0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.228101889059524748+1.43164485837168552e-16*%i -0.265594911883436868+1.5043391839391156e-16*%i 0.0825704304932580041-5.18240040696731648e-17*%i 
 0.273016906676211979+0*%i -0.00468434063869093212+0*%i -0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.228101889059524748+1.43164485837168552e-16*%i -0.265594911883436868+1.5043391839391156e-16*%i 0.0825704304932580041-5.18240040696731648e-17*%i 
 0.273016906676211979+0*%i -0.00468434063869093212+0*%i -0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[3
4
5];
yref=[-0.30906272225525161
 0.36412814585207276
0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.30906272225525161
 0.36412814585207276
0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.228144514233508455+0.00343724948069338773*%i -0.265639789156075279-0.0031069445819979849*%i 0.0825942221022646084-0.00553845279173677783*%i 
 0.273062336559663221-0.00185656517310216836*%i -0.00467875023595177783+0.00543836408021845449*%i -0.270840538797723684-0.000738422002625521083*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.223626950173899136+0.00336918738079998795*%i -0.260379768908271136-0.00304542295731204116*%i 0.0809587469274432592-0.0054287840786324832*%i 
 0.267655340025824695-0.00181980271958226327*%i -0.00458610477401360205+0.00533067725638924125*%i -0.265477536807215531-0.000723800267314064468*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[0];
yref=[ 0
-0
 1
 0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0
-0
 1
 0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[ 1.25e-15
-4.99999999999999647e-08
 0.999999999999997446
 4.99999999999999647e-08];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 1.25e-15
-4.99999999999999647e-08
 0.999999999999997446
 4.99999999999999647e-08];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[1];
yref=[ 0.114903484931900501
-0.440050585744933553
 0.765197686557966605
 0.440050585744933553];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.114903484931900501
-0.440050585744933553
 0.765197686557966605
 0.440050585744933553];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[3 4 5];
yref=[0.486091260585891194 -0.339058958525936538 -0.260051954901933557 0.339058958525936538
 0.36412814585207276 0.0660433280235490638 -0.397149809863847236 -0.0660433280235490638
0.046565116277752297 0.327579137591465064 -0.177596771314338348 -0.327579137591465064];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[0.486091260585891194 -0.339058958525936538 -0.260051954901933557 0.339058958525936538
 0.36412814585207276 0.0660433280235490638 -0.397149809863847236 -0.0660433280235490638
0.046565116277752297 0.327579137591465064 -0.177596771314338348 -0.327579137591465064];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ -0.265594911883436868+1.5043391839391156e-16*%i 0.0825704304932580041-5.18240040696731648e-17*%i 0.288216947635014376-1.63247121237385119e-16*%i -0.0825704304932580041+5.18240040696731648e-17*%i 
-0.00468434063869093212+0*%i -0.270786268276835385+0*%i 0.0691572616569850473+0*%i 0.270786268276835385+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.265594911883436868+1.5043391839391156e-16*%i 0.0825704304932580041-5.18240040696731648e-17*%i 0.288216947635014376-1.63247121237385119e-16*%i -0.0825704304932580041+5.18240040696731648e-17*%i 
-0.00468434063869093212+0*%i -0.270786268276835385+0*%i 0.0691572616569850473+0*%i 0.270786268276835385+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -0.265639789156075279-0.0031069445819979849*%i 0.0825942221022646084-0.00553845279173677783*%i 0.288272330491939344+0.00165156721805876858*%i -0.0825942221022646084+0.00553845279173677783*%i 
-0.00467875023595177783+0.00543836408021845449*%i -0.270840538797723684-0.000738422002625521083*%i 0.0691646458471141812-0.00541608716438180676*%i 0.270840538797723684+0.000738422002625521083*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -0.260379768908271136-0.00304542295731204116*%i 0.0809587469274432592-0.0054287840786324832*%i 0.282564155899245439+0.0016188639960181446*%i -0.0809587469274432592+0.0054287840786324832*%i 
-0.00458610477401360205+0.00533067725638924125*%i -0.265477536807215531-0.000723800267314064468*%i 0.0677950940990729028-0.00530884145304078969*%i 0.265477536807215531+0.000723800267314064468*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
 0
 -0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
 0
 -0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ -716418914.617646098
 119.403152436272933
8.52879660259094751e-06
2.50846958899734603e-13];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ -716418914.617646098
 119.403152436272933
8.52879660259094751e-06
2.50846958899734603e-13];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[-0.962671286840223628
 0.633870726369385018
 0.582348851018592018
 0.181417665056644584];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.962671286840223739
 0.633870726369385018
 0.582348851018592018
 0.181417665056644584];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[-0.106536302179580183 -0.40675205644906709 0.187886713469395089 0.494432522734784052
 0.268869311811566036 -0.344459534063007056 -0.217200381702116863 0.268439400467269551
 0.359445845778418371 -0.0150494093195678302 -0.357639916660074997 -0.0850897673452510606];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.106536302179580156 -0.406752056449067145 0.187886713469395089 0.494432522734784052
 0.268869311811565981 -0.344459534063007056 -0.217200381702116863 0.268439400467269551
 0.359445845778418316 -0.0150494093195678025 -0.357639916660074997 -0.0850897673452510606];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.12542315847504959-0.172630167733447554*%i 0.133575862270551238-0.183851401840542522*%i -0.114444320480207362+0.157519093609566369*%i -0.111627636425035953+0.153642260600349023*%i 
-0.26289292206878756+0*%i -0.0606892109991253315+0*%i 0.267227865711584134+0*%i 0.105227188617724732+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.125423158475049479-0.172630167733447665*%i 0.13357586227055121-0.183851401840542578*%i -0.114444320480207362+0.157519093609566369*%i -0.111627636425035953+0.153642260600349023*%i 
-0.262892922068787505+0*%i -0.0606892109991253037+0*%i 0.267227865711584134+0*%i 0.105227188617724732+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.122388153838117283-0.174892716810286619*%i 0.136900984596519226-0.181484735590922708*%i -0.111095235613447238+0.160007102702057979*%i -0.115511137516278492+0.150857044242800997*%i 
-0.262941829098775337+0.00202766723967471967*%i -0.0607076451088290336-0.00530154123317297127*%i 0.267278966499405468-0.00165931224063856075*%i 0.10525322854217678+0.00491892828012802791*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.119964706020585635-0.171429608988457022*%i 0.134190163475896684-0.177891097051649821*%i -0.108895402559002416+0.156838749788214965*%i -0.113223863745610387+0.147869874625772002*%i 
-0.257735232039471018+0.00198751673823663755*%i -0.0595055531952515537-0.00519656368323724409*%i 0.261986488365517967-0.0016264556568755667*%i 0.103169074978294403+0.00482152697427259275*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
-%inf
 0
 -0];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
 0
 -0];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 18626891780058596
 -716418914.617646098
 119.403152436272933
8.52879660259094751e-06
2.50846958899734603e-13];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 18626891780058600
 -716418914.617646098
 119.403152436272933
8.52879660259094751e-06
2.50846958899734603e-13];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ 1.86907461941519504
-0.962671286840223628
 0.633870726369385018
 0.582348851018592018
 0.181417665056644584];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 1.86907461941519526
-0.962671286840223739
 0.633870726369385018
 0.582348851018592018
 0.181417665056644584];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[ 0.499083518338036658 -0.106536302179580183 -0.40675205644906709 0.187886713469395089 0.494432522734784052
 0.16969448138548901 0.268869311811566036 -0.344459534063007056 -0.217200381702116863 0.268439400467269551
-0.171862430485209827 0.359445845778418371 -0.0150494093195678302 -0.357639916660074997 -0.0850897673452510606];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[ 0.499083518338036658 -0.106536302179580156 -0.406752056449067145 0.187886713469395089 0.494432522734784052
 0.169694481385489065 0.268869311811565981 -0.344459534063007056 -0.217200381702116863 0.268439400467269551
-0.171862430485209772 0.359445845778418316 -0.0150494093195678025 -0.357639916660074997 -0.0850897673452510606];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.0889046003479301572+0.122366684565615697*%i 0.12542315847504959-0.172630167733447554*%i 0.133575862270551238-0.183851401840542522*%i -0.114444320480207362+0.157519093609566369*%i -0.111627636425035953+0.153642260600349023*%i 
 0.142060829734702354+0*%i -0.26289292206878756+0*%i -0.0606892109991253315+0*%i 0.267227865711584134+0*%i 0.105227188617724732+0*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0889046003479302266+0.122366684565615863*%i 0.125423158475049479-0.172630167733447665*%i 0.13357586227055121-0.183851401840542578*%i -0.114444320480207362+0.157519093609566369*%i -0.111627636425035953+0.153642260600349023*%i 
 0.142060829734702354+0*%i -0.262892922068787505+0*%i -0.0606892109991253037+0*%i 0.267227865711584134+0*%i 0.105227188617724732+0*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.0931403526417651506+0.119314071061107668*%i 0.122388153838117283-0.174892716810286619*%i 0.136900984596519226-0.181484735590922708*%i -0.111095235613447238+0.160007102702057979*%i -0.115511137516278492+0.150857044242800997*%i 
 0.142092446056964028+0.00448015660911126913*%i -0.262941829098775337+0.00202766723967471967*%i -0.0607076451088290336-0.00530154123317297127*%i 0.267278966499405468-0.00165931224063856075*%i 0.10525322854217678+0.00491892828012802791*%i ];
y=besselj(alpha,x);
if testresult() then pause,end
yref=[-0.0912960500907815109+0.116951494160925568*%i 0.119964706020585635-0.171429608988457022*%i 0.134190163475896684-0.177891097051649821*%i -0.108895402559002416+0.156838749788214965*%i -0.113223863745610387+0.147869874625772002*%i 
 0.139278827111947917+0.00439144356445757625*%i -0.257735232039471018+0.00198751673823663755*%i -0.0595055531952515537-0.00519656368323724409*%i 0.261986488365517967-0.0016264556568755667*%i 0.103169074978294403+0.00482152697427259275*%i ];
y=besselj(alpha,x,1);
if testresult() then pause,end
// ------------------------------ besselk(alpha,x)------------------------------
//test of numerical precision reference computed by maple
exec(path+'besselk_ref.sce',-1)
besselK=besselk(alpha',x);
if norm((besselK-besselK_ref)./abs(besselK_ref),1)>1d6*%eps then pause,end

alpha=[];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[16.234027166616773];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[16.2340287900195683];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[0.421024438240708343];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.14446307980689488];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[0.0347395043862792421 0.0111596760858530247 0.00369109833404259336];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697761598043851849 0.609297669256695262 0.547807564313518958];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.000308362213060931921-699.503249938174008*%i 9.58800138559534094e-05+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.08310631727244942e-07-0.472541568707347648*%i 0.426384821387811808+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[ 0.0347395043862792421
 0.0111596760858530247
0.00369109833404259336];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697761598043851849
0.609297669256695262
0.547807564313518958];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.000308362213060931921-699.503249938174008*%i 
9.58800138559534094e-05+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.08310631727244942e-07-0.472541568707347648*%i 
 0.426384821387811808+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-12.9920245983972951-699.381145156678599*%i 9.58584235807003572e-05-2.02853533143100052e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000673690591289388989-0.472540114151826285*%i 0.426383961685526058-0.000494020086533254049*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[9999999.99999916367];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[10000000.999999214];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[0.601907230197234577];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.63615348626325807];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[0.0401564311281941769 0.0124834988872684315 0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.80656348012878698 0.681575945185670995 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[ 0.0401564311281941769
 0.0124834988872684315
0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 0.80656348012878698
0.681575945185670995
 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 
0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 
 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-12.2097820412575189-649.539559081750667*%i 0.000101411337448143222-2.15894410503202928e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000528666498849810103-0.438866355902376937*%i 0.451084799584356266-0.000579989976442809359*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[%inf %inf %inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf %inf %inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[9999999.99999916367 199999999999999.5 7.99999999999999056e+21];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[10000000.999999214 200000020000000.5 8.00000080000003028e+21];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[0.601907230197234577 1.62483889863517739 7.1012628247379439];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.63615348626325807 4.41677005233341102 19.3032336955969015];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[0.0401564311281941769 0.0174014255294872404 0.00829176841523093094];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.80656348012878698 0.950085641849530704 1.23060754505138759];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[ 0.0401564311281941769 0.0615104584717420244 0.122170375757183536
 0.0124834988872684315 0.0174014255294872404 0.0298849244167556718
0.00404461344545216286 0.00530894371222345902 0.00829176841523093094];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 0.80656348012878698 1.2354705847963765 2.45385759319062213
0.681575945185670995 0.950085641849530704 1.63166158703520159
 0.60027385878831252 0.787917107828843943 1.23060754505138759];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 0.000398455910810062441-521.515526255766758*%i -0.000547174002707648331-363.893259245845741*%i 
0.000101434481315590741+0*%i 0.00012003108083585597+0*%i 0.000158592138856474539+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 2.69172417957376988e-07-0.352303959851393844*%i -3.69637255607037082e-07-0.245824006652234722*%i 
 0.451085908928745838+0*%i 0.533786228275608399+0*%i 0.705269827155226015+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[%inf %inf %inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf %inf %inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[264928391.653412461 6358281399681985 2.79764381586007616e+23];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[264928418.14625293 6358282035510156 2.79764409562447141e+23];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[0.701079899557892183 2.10981175407567978 9.98425161749088552];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.90573275126611086 5.73506295257322485 27.1400097425883011];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[0.0427806945540970956 0.0190770205606465293 0.00924863337892758985];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.859273220065930987 1.04157003075555643 1.37261889714818142];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[ 0.0427806945540970956 0.0691669834332842848 0.144225603589580725
 0.0131117281572085929 0.0190770205606465293 0.0340964507739197759
0.00421016327579257221 0.0057255342081079727 0.00924863337892758985];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.859273220065930987 1.38925599961474155 2.89684868616755242
 0.71587610112107658 1.04157003075555643 1.86160313495218865
 0.62484363209802829 0.849744619375173871 1.37261889714818142];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.000273660347284653514-628.934159858371345*%i 0.000340084002811415643-490.660014148178334*%i -0.000478642485965506594-333.193877358099428*%i 
 0.000103975939764321327+0*%i 0.000125803839478814657+0*%i 0.000169873189015129033+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-1.84868175823797018e-07-0.424869412028293647*%i 2.2973993072224382e-07-0.331459864994254838*%i -3.23341558724874884e-07-0.225085383812578588*%i 
 0.462387944286756558+0*%i 0.559458071279206992+0*%i 0.755437410194912728+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[ 16.234027166616773
9999999.99999916367
 199999999999999.5];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[16.2340287900195683
 10000000.999999214
 200000020000000.5];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[0.421024438240708343
0.601907230197234577
 1.62483889863517739];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.14446307980689488
1.63615348626325807
4.41677005233341102];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[ 0.0347395043862792421 0.0401564311281941769 0.0615104584717420244
 0.0111596760858530247 0.0124834988872684315 0.0174014255294872404
0.00369109833404259336 0.00404461344545216286 0.00530894371222345902];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697761598043851849 0.80656348012878698 1.2354705847963765
0.609297669256695262 0.681575945185670995 0.950085641849530704
0.547807564313518958 0.60027385878831252 0.787917107828843943];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.000308362213060931921-699.503249938174008*%i -0.00032884199678432643-649.655191440786325*%i 0.000398455910810062441-521.515526255766758*%i 
9.58800138559534094e-05+0*%i 0.000101434481315590741+0*%i 0.00012003108083585597+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.08310631727244942e-07-0.472541568707347648*%i -2.22145519739981785e-07-0.438867272324231283*%i 2.69172417957376988e-07-0.352303959851393844*%i 
 0.426384821387811808+0*%i 0.451085908928745838+0*%i 0.533786228275608399+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[ 0.0347395043862792421
 0.0124834988872684315
0.00530894371222345902];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697761598043851849
0.681575945185670995
0.787917107828843943];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -12.9920245983972951-699.381145156678599*%i -12.2097820412575189-649.539559081750667*%i -10.1344510872378937-521.417272604113464*%i 
9.58584235807003572e-05-2.02853533143100052e-06*%i 0.000101411337448143222-2.15894410503202928e-06*%i 0.000120002619352898429-2.60005582256290754e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000673690591289388989-0.472540114151826285*%i 0.000528666498849810103-0.438866355902376937*%i 0.000199436595836125874-0.352304055696368024*%i 
 0.426383961685526058-0.000494020086533254049*%i 0.451084799584356266-0.000579989976442809359*%i 0.533784166806502203-0.000887827712164818541*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[0];
yref=[%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[16.5260271367940526
13840394.5854787864
 282344049543783.75];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[16.5260287893968467
13840395.9695183132
282344077778190.062];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[1];
yref=[0.421086004368149025
0.610465096726545031
 1.666434801690301];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.14463043389236563
1.65941617934026064
4.52983943974649783];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3 4 5];
yref=[ 0.0347415281841635393 0.0403909795851394096 0.0622073943020583359
 0.011160178106655122 0.0125399754302181927 0.0175555655760664016
0.00369123367515400772 0.00405955167518800598 0.00534753075863071432];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697802247110982043 0.81127451182103727 1.24946891514928726
0.609325078663767949 0.684659459950995308 0.958501403238775529
0.547827650715420389 0.602490888654808932 0.793643933286582448];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.000307761655715720745-699.482513886584456*%i -0.000329045760543045782-647.722648212824652*%i 0.00039971416962090062-518.475088906562405*%i 
9.58821756624346456e-05+0*%i 0.000101665303700313836+0*%i 0.000120572320846796583+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.07904931953827651e-07-0.472527560700454485*%i -2.22283170059975929e-07-0.437561764439004852*%i 2.70022420573327402e-07-0.350250026528458713*%i 
 0.426394435085529488+0*%i 0.452112391480472775+0*%i 0.536193158730787101+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3
4
5];
yref=[ 0.0347415281841635393
 0.0125399754302181927
0.00534753075863071432];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.697802247110982043
0.684659459950995308
0.793643933286582448];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -12.9917021581712788-699.360411772403722*%i -12.1791719472128612-647.607269472064104*%i -10.0840517737974746-518.377263453129899*%i 
9.58605847858665479e-05-2.0285859563972354e-06*%i 0.000101642094906378831-2.16437759701476455e-06*%i 0.000120543702111019878-2.6129898426369006e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000673628263176204037-0.47252610639182796*%i 0.000523235678055050842-0.437560866866200215*%i 0.00019240633416578646-0.350250141464640508*%i 
 0.426393575289366777-0.000494052966454036624*%i 0.452111271401550496-0.000583625737348904641*%i 0.536191067010032829-0.000897213244859404024*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[9999999.99999916367];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[10000000.999999214];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[0.601907230197234577];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.63615348626325807];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[0.0401564311281941769 0.0124834988872684315 0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.80656348012878698 0.681575945185670995 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[ 0.0401564311281941769
 0.0124834988872684315
0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 0.80656348012878698
0.681575945185670995
 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 
0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 
 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-12.2097820412575189-649.539559081750667*%i 0.000101411337448143222-2.15894410503202928e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000528666498849810103-0.438866355902376937*%i 0.451084799584356266-0.000579989976442809359*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[9999999.99999916367
39633272976.0599136];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[10000000.999999214
39633276939.387413];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[0.601907230197234577
0.922137008895789201];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.63615348626325807
2.50662827463100069];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[ 0.0401564311281941769 0.048034646842352785
 0.0124834988872684315 0.0143470307207600699
0.00404461344545216286 0.00453193604957145835];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 0.80656348012878698 0.964801672744356908
0.681575945185670995 0.78332133582218777
 0.60027385878831252 0.672598945967751494];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i -2.18157694632340212e-20-592.605824499197752*%i 
0.000101434481315590741+0*%i 0.000108816615756422952+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i -1.47373981831043786e-23-0.400328212854926313*%i 
 0.451085908928745838+0*%i 0.4839147535276207+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.00032884199678432643-649.655191440786325*%i 
0.000108816615756422952+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-2.22145519739981785e-07-0.438867272324231283*%i 
 0.4839147535276207+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -12.2097820412575189-649.539559081750667*%i -11.2973471089096531-592.497779249315954*%i 
0.000101411337448143222-2.15894410503202928e-06*%i 0.000108791381564593244-2.33325451860173617e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000528666498849810103-0.438866355902376937*%i 0.000374301098459614058-0.400327801467721511*%i 
 0.451084799584356266-0.000579989976442809359*%i 0.483913287047555762-0.000698657774352147171*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[0];
yref=[%inf
%inf
%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[7.99999999999999056e+21
 199999999999999.5
 9999999.99999916367
 16.234027166616773
 9999999.99999916367];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[8.00000080000003028e+21
 200000020000000.5
 10000000.999999214
 16.2340287900195683
 10000000.999999214];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[1];
yref=[ 7.1012628247379439
 1.62483889863517739
0.601907230197234577
0.421024438240708343
0.601907230197234577];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[19.3032336955969015
4.41677005233341102
1.63615348626325807
1.14446307980689488
1.63615348626325807];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[3 4 5];
yref=[ 0.122170375757183536 0.0615104584717420244 0.0401564311281941769 0.0347395043862792421 0.0401564311281941769
 0.0298849244167556718 0.0174014255294872404 0.0124834988872684315 0.0111596760858530247 0.0124834988872684315
0.00829176841523093094 0.00530894371222345902 0.00404461344545216286 0.00369109833404259336 0.00404461344545216286];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.45385759319062213 1.2354705847963765 0.80656348012878698 0.697761598043851849 0.80656348012878698
1.63166158703520159 0.950085641849530704 0.681575945185670995 0.609297669256695262 0.681575945185670995
1.23060754505138759 0.787917107828843943 0.60027385878831252 0.547807564313518958 0.60027385878831252];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.000547174002707648331-363.893259245845741*%i 0.000398455910810062441-521.515526255766758*%i -0.00032884199678432643-649.655191440786325*%i 0.000308362213060931921-699.503249938174008*%i -0.00032884199678432643-649.655191440786325*%i 
 0.000158592138856474539+0*%i 0.00012003108083585597+0*%i 0.000101434481315590741+0*%i 9.58800138559534094e-05+0*%i 0.000101434481315590741+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-3.69637255607037082e-07-0.245824006652234722*%i 2.69172417957376988e-07-0.352303959851393844*%i -2.22145519739981785e-07-0.438867272324231283*%i 2.08310631727244942e-07-0.472541568707347648*%i -2.22145519739981785e-07-0.438867272324231283*%i 
 0.705269827155226015+0*%i 0.533786228275608399+0*%i 0.451085908928745838+0*%i 0.426384821387811808+0*%i 0.451085908928745838+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -7.4394558673309259-363.818395117376156*%i -10.1344510872378937-521.417272604113464*%i -12.2097820412575189-649.539559081750667*%i -12.9920245983972951-699.381145156678599*%i -12.2097820412575189-649.539559081750667*%i 
0.000158552170065185956-3.53311552676922989e-06*%i 0.000120002619352898429-2.60005582256290754e-06*%i 0.000101411337448143222-2.15894410503202928e-06*%i 9.58584235807003572e-05-2.02853533143100052e-06*%i 0.000101411337448143222-2.15894410503202928e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-0.000109494840793429989-0.24582478609981806*%i 0.000199436595836125874-0.352304055696368024*%i 0.000528666498849810103-0.438866355902376937*%i 0.000673690591289388989-0.472540114151826285*%i 0.000528666498849810103-0.438866355902376937*%i 
 0.705265288619020159-0.00160795671803239896*%i 0.533784166806502203-0.000887827712164818541*%i 0.451084799584356266-0.000579989976442809359*%i 0.426383961685526058-0.000494020086533254049*%i 0.451084799584356266-0.000579989976442809359*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[%inf
%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[1391006872.97331595
231.820520515120165
83749.8825951008039
1172498356563.23169];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1391007012.07401013
231.820543697173349
83749.8909700894728
1172498473813.07324];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[0.763646889504661752
 0.43507602420880509
0.502601274979380563
 1.13871780917993615];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[2.07580746309979425
1.18265925060500243
1.36621191273679798
3.09535592843651486];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[ 0.0443421088885961254 0.0351976322831403024 0.0373025824319680663 0.0526055040847253977
 0.0134818491452645944 0.0112731687602682217 0.0117908738312243588 0.0153999746011967472
0.00430707882416860813 0.00372166932887342495 0.00386047850470379794 0.00480260331019048865];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.890635065333905684 0.706963342831796848 0.749242396767546337 1.05660979465665172
0.736084022357373691 0.61549415932207896 0.643759898459061786 0.840810123782750551
0.639227174798674413 0.552344702233271256 0.572945810530681943 0.712769529181862205];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.000202039933371823646-617.4753218485356*%i 0.000182303857757894639-694.85412883218396*%i -0.000187056054651996666-674.586620108726265*%i 0.00021817762166375702-565.48135237298743*%i 
 0.000105447291803287651+0*%i 9.63676106687086419e-05+0*%i 9.85638910412370219e-05+0*%i 0.000112794925842248141+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[-1.36485809130247718e-07-0.417128522633984811*%i 1.23153324782880659e-07-0.469400907129679523*%i -1.26363618052202399e-07-0.45570941911040358*%i 1.47387443313440241e-07-0.382004580177006337*%i 
 0.468931145013404105+0*%i 0.42855319696010008+0*%i 0.438320202373396861+0*%i 0.501606564022332835+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -11.6973470619133586-617.363942587298084*%i -12.9196695714012666-694.732622548455197*%i -12.6027889661243577-674.467734692398381*%i -10.8570953242124073-565.376995143766976*%i 
0.000105423015175112696-2.25356064547544274e-06*%i 9.63458846993802559e-05-2.03995644112665241e-06*%i 9.85415522099426799e-05-2.09146503547789611e-06*%i 0.000112768553688897494-2.42763553987181895e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[0.000440078414964279569-0.417127903442599313*%i 0.000659758483747528994-0.46939950740576919*%i 0.000600004710276078089-0.455708246718983245*%i 0.000305250372583931013-0.382004376550384939*%i 
 0.468929845046064608-0.000643891710835903762*%i 0.428552316018253054-0.000501447813605265108*%i 0.438319224140312547-0.000535191579136117934*%i 0.501604893533769691-0.000764581118498229096*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[%inf
%inf
%inf
%inf
%inf];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[%inf
%inf
%inf
%inf
%inf];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 36166178697306312
1391006872.97331595
231.820520515120165
83749.8825951008039
1172498356563.23169];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 36166182313924360
1391007012.07401013
231.820543697173349
83749.8909700894728
1172498473813.07324];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ 2.42055793692092536
0.763646889504661752
 0.43507602420880509
0.502601274979380563
 1.13871780917993615];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[6.57975865466446574
2.07580746309979425
1.18265925060500243
1.36621191273679798
3.09535592843651486];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[ 0.0736274599865902601 0.0443421088885961254 0.0351976322831403024 0.0373025824319680663 0.0526055040847253977
 0.0200363707046902068 0.0134818491452645944 0.0112731687602682217 0.0117908738312243588 0.0153999746011967472
0.00596135031744110186 0.00430707882416860813 0.00372166932887342495 0.00386047850470379794 0.00480260331019048865];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[ 1.47884706612118144 0.890635065333905684 0.706963342831796848 0.749242396767546337 1.05660979465665172
 1.09394877385437184 0.736084022357373691 0.61549415932207896 0.643759898459061786 0.840810123782750551
0.884742833128581818 0.639227174798674413 0.552344702233271256 0.572945810530681943 0.712769529181862205];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.000254263286082106045-474.93141146147201*%i -0.000202039933371823646-617.4753218485356*%i 0.000182303857757894639-694.85412883218396*%i -0.000187056054651996666-674.586620108726265*%i 0.00021817762166375702-565.48135237298743*%i 
0.000129006058131630997+0*%i 0.000105447291803287651+0*%i 9.63676106687086419e-05+0*%i 9.85638910412370219e-05+0*%i 0.000112794925842248141+0*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[1.71764708856667764e-07-0.320834583999766498*%i -1.36485809130247718e-07-0.417128522633984811*%i 1.23153324782880659e-07-0.469400907129679523*%i -1.26363618052202399e-07-0.45570941911040358*%i 1.47387443313440241e-07-0.382004580177006337*%i 
 0.573698551369010823+0*%i 0.468931145013404105+0*%i 0.42855319696010008+0*%i 0.438320202373396861+0*%i 0.501606564022332835+0*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -9.35593722522677851-474.839810853399911*%i -11.6973470619133586-617.363942587298084*%i -12.9196695714012666-694.732622548455197*%i -12.6027889661243577-674.467734692398381*%i -10.8570953242124073-565.376995143766976*%i 
0.000128974972208392366-2.81517542070003286e-06*%i 0.000105423015175112696-2.25356064547544274e-06*%i 9.63458846993802559e-05-2.03995644112665241e-06*%i 9.85415522099426799e-05-2.09146503547789611e-06*%i 0.000112768553688897494-2.42763553987181895e-06*%i ];
y=besselk(alpha,x);
if testresult() then pause,end
yref=[9.59920399783527394e-05-0.320834949375373546*%i 0.000440078414964279569-0.417127903442599313*%i 0.000659758483747528994-0.46939950740576919*%i 0.000600004710276078089-0.455708246718983245*%i 0.000305250372583931013-0.382004376550384939*%i 
 0.573695970723117288-0.00104632775911367567*%i 0.468929845046064608-0.000643891710835903762*%i 0.428552316018253054-0.000501447813605265108*%i 0.438319224140312547-0.000535191579136117934*%i 0.501604893533769691-0.000764581118498229096*%i ];
y=besselk(alpha,x,1);
if testresult() then pause,end
// ------------------------------ bessely(alpha,x)------------------------------
//test of numerical precision reference computed by maple
exec(path+'bessely_ref.sce',-1)
besselY=bessely(alpha',x);
if norm((besselY-besselY_ref)./abs(besselY_ref),1)>1d6*%eps then pause,end

alpha=[];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[-10.3349026794206473];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-10.3349026794206473];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[0.0882569642156769973];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0882569642156769696];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[0.376850010012790504 -0.0169407393250650198 -0.308517625249033867];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.376850010012790504 -0.0169407393250650129 -0.308517625249033811];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0627738863740378017+0.576433895270028751*%i 0.266221867363905018+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0627738863740374964+0.576433895270028751*%i 0.266221867363905074+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[ 0.376850010012790504
-0.0169407393250650198
 -0.308517625249033867];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.376850010012790504
-0.0169407393250650129
 -0.308517625249033811];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.0627738863740378017+0.576433895270028751*%i 
 0.266221867363905018+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0627738863740374964+0.576433895270028751*%i 
 0.266221867363905074+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0594911047067641363+0.570852419787944876*%i 0.266276386958715638+0.00106971720159772243*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0583131019071235768+0.55954878453009449*%i 0.261003761229849252+0.00104853538181959999*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[-6366197.72367634624];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-6366197.72367634624];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[-0.781212821300288907];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.781212821300288907];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[0.324674424791800087 0.397925710557099965 0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.324674424791800031 0.397925710557100021 0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.28459437186807196-0.165140860986515869*%i -0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.28459437186807196-0.165140860986515869*%i -0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[0.324674424791800087
0.397925710557099965
0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.324674424791800031
0.397925710557100021
0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ 0.28459437186807196-0.165140860986515869*%i 
-0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.28459437186807196-0.165140860986515869*%i 
-0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.273570530695402159-0.163153078769770365*%i -0.053488563419309812+0.00545213754945528262*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.268153471243458119-0.159922431356041589*%i -0.0524294189006919362+0.00534417799266206917*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[-%inf -%inf -%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf -%inf -%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[-6366197.72367634624 -127323954473516.594 -5.09295817894065707e+21];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-6366197.72367634624 -127323954473516.578 -5.09295817894065812e+21];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[-0.781212821300288907 -1.65068260681625478 -5.82151760596473089];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.781212821300288907 -1.65068260681625478 -5.82151760596473089];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[0.324674424791800087 0.215903594603614996 0.146267162693192898];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.324674424791800031 0.215903594603615023 0.14626716269319287];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[0.324674424791800087 -0.16040039348492377 -0.538541616105031817
0.397925710557099965 0.215903594603615023 -0.182022115953484942
0.147863143391226859 0.367662882605524655 0.146267162693192898];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.324674424791800031 -0.160400393484923798 -0.538541616105031817
0.397925710557100021 0.215903594603615051 -0.182022115953484942
0.147863143391226803 0.367662882605524544 0.14626716269319287];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ 0.28459437186807196-0.165140860986515869*%i -0.140744947159810951-0.531189823766873737*%i -0.207473852876394749+0.456203778119049386*%i 
-0.0534845083974161278+0*%i -0.278956274125194581+0*%i -0.0793518126145812824+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.28459437186807196-0.165140860986515869*%i -0.140744947159811229-0.531189823766873737*%i -0.207473852876394638+0.456203778119049441*%i 
-0.0534845083974161833+0*%i -0.278956274125194637+0*%i -0.0793518126145812824+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[-%inf -%inf -%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf -%inf -%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[-168658652.388109088 -4047807657314589 -1.78103536921841748e+23];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-168658652.388109088 -4047807657314589.5 -1.78103536921841714e+23];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[-0.901214954842308846 -2.02168904229560242 -7.99421683125834193];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.901214954842308735 -2.02168904229560242 -7.99421683125834193];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[0.236105148830688782 0.137707238974328822 0.0774312728572489062];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.236105148830688782 0.137707238974328877 0.0774312728572488507];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[0.236105148830688782 -0.249464037123650451 -0.601985736612042799
0.404200660729673644 0.137707238974328822 -0.25272269785791196
0.231079618553641175 0.350580558421466015 0.0774312728572489062];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.236105148830688782 -0.249464037123650617 -0.60198573661204291
 0.4042006607296737 0.137707238974328877 -0.252722697857912071
0.231079618553641009 0.350580558421465849 0.0774312728572488507];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.240226585254262215-0.173655347820190264*%i -0.0558641372965151817-0.434822373349611213*%i -0.206555050445403759+0.435740066003517668*%i 
-0.12841584805211595+0*%i -0.268892924189574611+0*%i -0.0124328265233755314+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.24022658525426227-0.173655347820190098*%i -0.0558641372965149458-0.434822373349611269*%i -0.206555050445404065+0.435740066003517612*%i 
-0.128415848052115866+0*%i -0.268892924189574556+0*%i -0.0124328265233754898+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[-10.3349026794206473
-6366197.72367634624
-127323954473516.594];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-10.3349026794206473
-6366197.72367634624
-127323954473516.578];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[0.0882569642156769973
-0.781212821300288907
 -1.65068260681625478];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0882569642156769696
-0.781212821300288907
 -1.65068260681625478];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[ 0.376850010012790504 0.324674424791800087 -0.160400393484923798
-0.0169407393250650198 0.397925710557099965 0.215903594603614996
 -0.308517625249033867 0.147863143391226887 0.367662882605524655];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.376850010012790504 0.324674424791800031 -0.160400393484923853
-0.0169407393250650129 0.397925710557100021 0.215903594603615023
 -0.308517625249033811 0.147863143391226831 0.367662882605524544];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0627738863740378017+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i -0.140744947159810951-0.531189823766873737*%i 
 0.266221867363905018+0*%i -0.0534845083974161417+0*%i -0.278956274125194581+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0627738863740374964+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i -0.140744947159811201-0.531189823766873737*%i 
 0.266221867363905074+0*%i -0.0534845083974161833+0*%i -0.278956274125194637+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[0.376850010012790504
0.397925710557099965
0.367662882605524655];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.376850010012790504
0.397925710557100021
0.367662882605524544];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0594911047067641363+0.570852419787944876*%i 0.273570530695402159-0.163153078769770365*%i -0.134563835842271912-0.526358624867831137*%i 
 0.266276386958715638+0.00106971720159772243*%i -0.0534885634193098258+0.00545213754945528262*%i -0.279008596242427576+0.000258725570376667352*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0583131019071235768+0.55954878453009449*%i 0.268153471243458119-0.159922431356041589*%i -0.131899293367662818-0.515936025779016094*%i 
 0.261003761229849252+0.00104853538181959999*%i -0.0524294189006919362+0.00534417799266206917*%i -0.273483855878007609+0.000253602460833710075*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[0];
yref=[-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[-10.5435018262277929
-8811068.85048608482
-179745804549905.625];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-10.5435018262277929
-8811068.85048608482
-179745804549905.656];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[1];
yref=[0.0643040307807657419
-0.793245652497184595
 -1.68252516187502232];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0643040307807657419
-0.793245652497184706
 -1.68252516187502277];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3 4 5];
yref=[ 0.384820425921874987 0.316452158174697407 -0.169632958363080733
-0.00447693217669133808 0.399776541248366868 0.208362968213358424
 -0.302795423995985136 0.15685459545204769 0.366792098940420641];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.384820425921874987 0.316452158174697407 -0.169632958363080816
-0.00447693217669134502 0.399776541248366868 0.208362968213358452
 -0.302795423995985136 0.156854595452047746 0.366792098940420641];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0535918058658350627+0.575574764795366067*%i 0.286331738254591017-0.166506620507523545*%i -0.133607798473967337-0.529044147557647282*%i 
 0.26392041753001122+0*%i -0.0613287659781691918+0*%i -0.278814546410423747+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0535918058658351945+0.575574764795366067*%i 0.286331738254590962-0.166506620507523573*%i -0.13360779847396731-0.52904414755764706*%i 
 0.26392041753001122+0*%i -0.061328765978169178+0*%i -0.278814546410423747+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3
4
5];
yref=[0.384820425921874987
0.399776541248366868
0.366792098940420641];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.384820425921874987
0.399776541248366868
0.366792098940420641];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0503114628539832326+0.569955434445619136*%i 0.27533846887479968-0.164682242384238758*%i -0.127380869613414494-0.524145792482789141*%i 
 0.263974678263304063+0.00123918133456109997*%i -0.061334389730632502+0.00542770518273297253*%i -0.278866950019879489+0.000114433428284946292*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.0493152291415966115+0.55866956068757101*%i 0.269886401901392015-0.161421315502212115*%i -0.12485855939972948-0.513767010410947855*%i 
 0.258747629420268188+0.00121464390012337303*%i -0.0601198874420454457+0.00532022941921519998*%i -0.273345014438587053+0.000112167494586902505*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[6366197.72367634624];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[6366197.72367634624];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[0.781212821300288907];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.781212821300288907];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[-0.324674424791800087 -0.397925710557099965 -0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.324674424791800031 -0.397925710557100021 -0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.28459437186807196+0.165140860986515869*%i 0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.28459437186807196+0.165140860986515869*%i 0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[-0.324674424791800087
-0.397925710557099965
-0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.324674424791800031
-0.397925710557100021
-0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ -0.28459437186807196+0.165140860986515869*%i 
0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.28459437186807196+0.165140860986515869*%i 
0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.273570530695402159+0.163153078769770365*%i 0.053488563419309812-0.00545213754945528262*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.268153471243458119+0.159922431356041589*%i 0.0524294189006919362-0.00534417799266206917*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[ 6366197.72367634624
4.63475776656093441e-06];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 6366197.72367634624
4.63475776656093441e-06];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[ 0.781212821300288907
-0.240297839123427059];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.781212821300288907
-0.240297839123427059];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[-0.324674424791800087 -0.477718215087092224
-0.397925710557099965 -0.185285948354267732
-0.147863143391226859 0.169651306144741165];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.324674424791800031 -0.477718215087092224
-0.397925710557100021 -0.185285948354267732
-0.147863143391226803 0.169651306144741165];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ -0.28459437186807196+0.165140860986515869*%i -1.66533453693773654e-16-0.120953010973629607*%i 
0.0534845083974161278+0*%i -0.170966347821113557+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.28459437186807196+0.165140860986515869*%i -1.66533453693773654e-16-0.120953010973629607*%i 
0.0534845083974161833+0*%i -0.170966347821113557+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[ -0.28459437186807196+0.165140860986515869*%i 
-0.170966347821113557+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.28459437186807196+0.165140860986515869*%i 
-0.170966347821113557+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.273570530695402159+0.163153078769770365*%i 0.00552027940993567862-0.120968618958143467*%i 
 0.053488563419309812-0.00545213754945528262*%i -0.171004326769525289-0.00409499672885600772*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.268153471243458119+0.159922431356041589*%i 0.00541097055390155068-0.118573279814522647*%i 
0.0524294189006919362-0.00534417799266206917*%i -0.16761821422920356-0.00401391036082020345*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[0];
yref=[-%inf
-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[5.09295817894065707e+21
 -127323954473516.594
 6366197.72367634624
 -10.3349026794206473
 -6366197.72367634624];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[5.09295817894065812e+21
 -127323954473516.578
 6366197.72367634624
 -10.3349026794206473
 -6366197.72367634624];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[1];
yref=[ 5.82151760596473089
 -1.65068260681625478
 0.781212821300288907
0.0882569642156769973
-0.781212821300288907];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 5.82151760596473089
 -1.65068260681625478
 0.781212821300288907
0.0882569642156769696
-0.781212821300288907];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[3 4 5];
yref=[ 0.538541616105031817 -0.160400393484923798 -0.324674424791800087 0.376850010012790504 0.324674424791800087
 0.182022115953484942 0.215903594603614996 -0.397925710557099965 -0.0169407393250650198 0.397925710557099965
-0.146267162693192898 0.367662882605524655 -0.147863143391226859 -0.308517625249033867 0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.538541616105031817 -0.160400393484923853 -0.324674424791800031 0.376850010012790504 0.324674424791800031
0.182022115953484942 0.215903594603615023 -0.397925710557100021 -0.0169407393250650129 0.397925710557100021
-0.14626716269319287 0.367662882605524544 -0.147863143391226803 -0.308517625249033811 0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.207473852876394749-0.456203778119049386*%i -0.140744947159810951-0.531189823766873737*%i -0.28459437186807196+0.165140860986515869*%i 0.0627738863740378017+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i 
0.0793518126145812824+0*%i -0.278956274125194581+0*%i 0.0534845083974161278+0*%i 0.266221867363905018+0*%i -0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.207473852876394638-0.456203778119049441*%i -0.140744947159811201-0.531189823766873737*%i -0.28459437186807196+0.165140860986515869*%i 0.0627738863740374964+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i 
0.0793518126145812824+0*%i -0.278956274125194637+0*%i 0.0534845083974161833+0*%i 0.266221867363905074+0*%i -0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.200627649489689364-0.451768607139008516*%i -0.134563835842271912-0.526358624867831137*%i -0.273570530695402159+0.163153078769770365*%i 0.0594911047067641363+0.570852419787944876*%i 0.273570530695402159-0.163153078769770365*%i 
0.0793716263712800352+0.00501260111167922684*%i -0.279008596242427576+0.000258725570376667352*%i 0.053488563419309812-0.00545213754945528262*%i 0.266276386958715638+0.00106971720159772243*%i -0.053488563419309812+0.00545213754945528262*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.196654955858446223-0.44282298935929687*%i -0.131899293367662818-0.515936025779016094*%i -0.268153471243458119+0.159922431356041589*%i 0.0583131019071235768+0.55954878453009449*%i 0.268153471243458119-0.159922431356041589*%i 
0.0777999628673285148+0.00491334495948420047*%i -0.273483855878007609+0.000253602460833710075*%i 0.0524294189006919362-0.00534417799266206917*%i 0.261003761229849252+0.00104853538181959999*%i -0.0524294189006919362+0.00534417799266206917*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[0];
yref=[-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[-127323954473516.594
 6366197.72367634624
-10.3349026794206473
-6366197.72367634624];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-127323954473516.578
 6366197.72367634624
-10.3349026794206473
-6366197.72367634624];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[1];
yref=[ -1.65068260681625478
 0.781212821300288907
0.0882569642156769973
-0.781212821300288907];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -1.65068260681625478
 0.781212821300288907
0.0882569642156769696
-0.781212821300288907];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[3 4 5];
yref=[-0.160400393484923798 -0.324674424791800087 0.376850010012790504 0.324674424791800087
 0.215903594603614996 -0.397925710557099965 -0.0169407393250650198 0.397925710557099965
 0.367662882605524655 -0.147863143391226859 -0.308517625249033867 0.147863143391226859];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.160400393484923853 -0.324674424791800031 0.376850010012790504 0.324674424791800031
 0.215903594603615023 -0.397925710557100021 -0.0169407393250650129 0.397925710557100021
 0.367662882605524544 -0.147863143391226803 -0.308517625249033811 0.147863143391226803];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.140744947159810951-0.531189823766873737*%i -0.28459437186807196+0.165140860986515869*%i 0.0627738863740378017+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i 
-0.278956274125194581+0*%i 0.0534845083974161278+0*%i 0.266221867363905018+0*%i -0.0534845083974161278+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.140744947159811201-0.531189823766873737*%i -0.28459437186807196+0.165140860986515869*%i 0.0627738863740374964+0.576433895270028751*%i 0.28459437186807196-0.165140860986515869*%i 
-0.278956274125194637+0*%i 0.0534845083974161833+0*%i 0.266221867363905074+0*%i -0.0534845083974161833+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.134563835842271912-0.526358624867831137*%i -0.273570530695402159+0.163153078769770365*%i 0.0594911047067641363+0.570852419787944876*%i 0.273570530695402159-0.163153078769770365*%i 
-0.279008596242427576+0.000258725570376667352*%i 0.053488563419309812-0.00545213754945528262*%i 0.266276386958715638+0.00106971720159772243*%i -0.053488563419309812+0.00545213754945528262*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.131899293367662818-0.515936025779016094*%i -0.268153471243458119+0.159922431356041589*%i 0.0583131019071235768+0.55954878453009449*%i 0.268153471243458119-0.159922431356041589*%i 
-0.273483855878007609+0.000253602460833710075*%i 0.0524294189006919362-0.00534417799266206917*%i 0.261003761229849252+0.00104853538181959999*%i -0.0524294189006919362+0.00534417799266206917*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 520508809.337161601
-86.7425820843251785
-53316.8312102425552
-746435636856.653198];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 520508809.337161541
-86.7425820843251785
-53316.8312102425552
-746435636856.653198];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ 0.314183689901754548
 0.454431262899763211
-0.586842447641611864
 -1.27601068959802011];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ 0.314183689901754548
 0.454431262899763155
-0.586842447641611864
 -1.27601068959802033];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[-0.466080611113182774 0.212390924829804428 0.423602426147222433 -0.014709792627767504
-0.306380088504755232 -0.199425513451468028 0.336293915522475506 0.317128383884334675
0.0416545814756713872 -0.355966921924181279 0.00106144915522857208 0.356264127687647869];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.466080611113182774 0.212390924829804484 0.423602426147222433 -0.0147097926277675942
-0.306380088504755177 -0.199425513451468028 0.336293915522475562 0.317128383884334619
0.0416545814756714428 -0.355966921924181279 0.00106144915522855821 0.356264127687647758];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ -0.121666717696636423+0.0833864463893779634*%i 0.110649033008904024+0.419447053092179445*%i 0.130761158765862334-0.0489113461352237433*%i -0.135726515511943424-0.4100667949292639*%i 
-0.0862806191484301321+0*%i 0.268366926287593732+0*%i 0.0671115529850285913+0*%i -0.257181667456753915+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.12166671769663634+0.0833864463893780328*%i 0.110649033008904024+0.4194470530921795*%i 0.130761158765862362-0.0489113461352239931*%i -0.135726515511943285-0.4100667949292639*%i 
-0.086280619148430146+0*%i 0.268366926287593677+0*%i 0.0671115529850285913+0*%i -0.257181667456753915+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ -0.113594218202467456+0.080767182276823099*%i 0.109351445375408682+0.417004570698233712*%i 0.122488039151380818-0.046468467367517037*%i -0.132866541475518879-0.408157234754056908*%i 
-0.0863035346120157726-0.00510058899774245254*%i 0.268418706707374222-0.00153406339209650328*%i 0.0671311394293841734+0.00525581351428117127*%i -0.25722816126732434+0.0023833881553354877*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -0.111344901977376662+0.0791678849144669128*%i 0.107186141681151675+0.408747326961261703*%i 0.120062613472129431-0.0455483300642385985*%i -0.130235607681160659-0.400075180006480513*%i 
-0.0845946101283816532-0.00499959056867008752*%i 0.263103660205283252-0.00150368690170144784*%i 0.0658018538062531688+0.00515174143384616867*%i -0.252134702411367373+0.00233619390783472436*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[-%inf
-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-%inf
-%inf
-%inf
-%inf
-%inf];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ -13533229042766080
 520508809.337161601
-86.7425820843251785
-53316.8312102425552
-746435636856.653198];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -13533229042766082
 520508809.337161541
-86.7425820843251785
-53316.8312102425552
-746435636856.653198];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ -1.27130885664432558
 0.314183689901754548
 0.454431262899763211
-0.586842447641611864
 -1.27601068959802011];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[ -1.2713088566443258
 0.314183689901754548
 0.454431262899763155
-0.586842447641611864
 -1.27601068959802033];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[0.191545604801620084 -0.466080611113182774 0.212390924829804428 0.423602426147222433 -0.014709792627767504
0.398572570979558172 -0.306380088504755232 -0.199425513451468028 0.336293915522475506 0.317128383884334675
0.334306539556831872 0.0416545814756713872 -0.355966921924181279 0.00106144915522857208 0.356264127687647869];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[0.191545604801620056 -0.466080611113182774 0.212390924829804484 0.423602426147222433 -0.0147097926277675942
0.398572570979558116 -0.306380088504755177 -0.199425513451468028 0.336293915522475562 0.317128383884334619
0.334306539556831872 0.0416545814756714428 -0.355966921924181279 0.00106144915522855821 0.356264127687647758];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.153982384517294985-0.389747770816509909*%i -0.121666717696636423+0.0833864463893779634*%i 0.110649033008904024+0.419447053092179445*%i 0.130761158765862334-0.0489113461352237433*%i -0.135726515511943424-0.4100667949292639*%i 
-0.241661020360698642+0*%i -0.0862806191484301321+0*%i 0.268366926287593732+0*%i 0.0671115529850285913+0*%i -0.257181667456753915+0*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.153982384517294929-0.38974777081651002*%i -0.12166671769663634+0.0833864463893780328*%i 0.110649033008904024+0.4194470530921795*%i 0.130761158765862362-0.0489113461352239931*%i -0.135726515511943285-0.4100667949292639*%i 
-0.241661020360698614+0*%i -0.086280619148430146+0*%i 0.268366926287593677+0*%i 0.0671115529850285913+0*%i -0.257181667456753915+0*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.149888167842517933-0.388349236524206054*%i -0.113594218202467456+0.080767182276823099*%i 0.109351445375408682+0.417004570698233712*%i 0.122488039151380818-0.046468467367517037*%i -0.132866541475518879-0.408157234754056908*%i 
-0.241702100416107291+0.00304920616213296336*%i -0.0863035346120157726-0.00510058899774245254*%i 0.268418706707374222-0.00153406339209650328*%i 0.0671311394293841734+0.00525581351428117127*%i -0.25722816126732434+0.0023833881553354877*%i ];
y=bessely(alpha,x);
if testresult() then pause,end
yref=[-0.146920183263616416-0.380659406420718049*%i -0.111344901977376662+0.0791678849144669128*%i 0.107186141681151675+0.408747326961261703*%i 0.120062613472129431-0.0455483300642385985*%i -0.130235607681160659-0.400075180006480513*%i 
-0.236916078163324606+0.00298882783476134631*%i -0.0845946101283816532-0.00499959056867008752*%i 0.263103660205283252-0.00150368690170144784*%i 0.0658018538062531688+0.00515174143384616867*%i -0.252134702411367373+0.00233619390783472436*%i ];
y=bessely(alpha,x,1);
if testresult() then pause,end
// ------------------------------ besselh(alpha[,K],x)------------------------------

alpha=[];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[0];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[9.99999999999999955e-08];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[1];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[3 4 5];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982 8.40000000000000036];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[3
4
5];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[0];
yref=[%nan+%nan*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan+%nan*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan+%nan*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[9.99999999999999955e-08];
yref=[0.999999999999997446-10.3349026794206473*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.999999999999997446+10.3349026794206473*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.999998966509724529-10.3349027794205952*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[1];
yref=[0.765197686557966383+0.0882569642156769973*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.765197686557966383-0.0882569642156769973*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.487703749086956295-0.596206209606004012*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[3 4 5];
yref=[-0.260051954901933502+0.376850010012790504*%i -0.397149809863847292-0.0169407393250650198*%i -0.177596771314338348-0.308517625249033867*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933502-0.376850010012790504*%i -0.397149809863847292+0.0169407393250650198*%i -0.177596771314338348+0.308517625249033867*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.31063056052955762-0.336380148284720293*%i 0.272415233538270574-0.289490760923486856*%i 0.245467551730485706-0.257816638947182653*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.288216947635014376+0.0627738863740376352*%i 0.0691572616569851861+0.266221867363905018*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.864650842905043127-0.0627738863740379682*%i 0.0691572616569851861-0.266221867363905018*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.205009668070646411-0.212086316654584245*%i 0.191600335830164975-0.197347715498268128*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[3
4
5];
yref=[-0.260051954901933502+0.376850010012790504*%i 
-0.397149809863847292-0.0169407393250650198*%i 
-0.177596771314338348-0.308517625249033867*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933502-0.376850010012790504*%i 
-0.397149809863847292+0.0169407393250650198*%i 
-0.177596771314338348+0.308517625249033867*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.31063056052955762-0.336380148284720293*%i 
0.272415233538270574-0.289490760923486856*%i 
0.245467551730485706-0.257816638947182653*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.288216947635014376+0.0627738863740376352*%i 
0.0691572616569851861+0.266221867363905018*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.864650842905043127-0.0627738863740379682*%i 
0.0691572616569851861-0.266221867363905018*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.205009668070646411-0.212086316654584245*%i 
 0.191600335830164975-0.197347715498268128*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.282580089296005532+0.0611426719248229084*%i 0.0680949286455164587+0.260860299794333839*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.859124750279884219-0.0578395374887053712*%i 0.0702343630487119036-0.271692474123097438*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.204710539394216295-0.212355593630163458*%i 0.191359168939230689-0.197567749205550591*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[0];
yref=[%nan+%nan*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan+%nan*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan+%nan*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[9.99999999999999955e-08];
yref=[5.03898043091051198e-08-6366197.72367634624*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[5.03898043091051198e-08+6366197.72367634624*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.636619721977829234-6366197.72367631458*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[1];
yref=[0.440050585744933553-0.781212821300288907*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.440050585744933553+0.781212821300288907*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.419607575907496144-0.792380888474382039*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[3 4 5];
yref=[0.339058958525936538+0.324674424791800087*%i -0.0660433280235491887+0.397925710557099965*%i -0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.339058958525936538-0.324674424791800087*%i -0.0660433280235491887-0.397925710557099965*%i -0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.289847767402387269-0.369273247341898037*%i -0.257982370633597746-0.310083357729930509*%i -0.234711371607197739-0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0825704304932578653+0.284594371868072016*%i 0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.247711291479773887-0.284594371868071905*%i 0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.198591028778410006+0.219939618485522376*%i -0.186324039282828008-0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[3
4
5];
yref=[ 0.339058958525936538+0.324674424791800087*%i 
-0.0660433280235491887+0.397925710557099965*%i 
 -0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.339058958525936538-0.324674424791800087*%i 
-0.0660433280235491887-0.397925710557099965*%i 
 -0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.289847767402387269-0.369273247341898037*%i 
-0.257982370633597746-0.310083357729930509*%i 
-0.234711371607197739-0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.0825704304932578653+0.284594371868072016*%i 
 0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.247711291479773887-0.284594371868071905*%i 
 0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.198591028778410006+0.219939618485522376*%i 
-0.186324039282828008-0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0805588566675057155+0.279108983487138917*%i 0.265388401248268402-0.0527501414166842708*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.245747300872035002-0.268032077903665344*%i 0.276292676347178967+0.0542269854219353462*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.198923241476530482+0.219693383394633845*%i -0.186588090699604608-0.203436398574806665*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[0];
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[9.99999999999999955e-08];
yref=[5.03898043091051198e-08-6366197.72367634624*%i 1.27222187258540667e-15-127323954473516.594*%i 311843.447284119495-5.09295817894065707e+21*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[5.03898043091051198e-08+6366197.72367634624*%i 1.27222187258540667e-15+127323954473516.594*%i 311843.447284119495+5.09295817894065707e+21*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.636619721977829234-6366197.72367631458*%i -12732395.4473516364-127323954473515.953*%i -509295817582221.438-5.09295817894063191e+21*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[1];
yref=[0.440050585744933553-0.781212821300288907*%i 0.114903484931900571-1.65068260681625478*%i 0.0195633539826691495-5.82151760596473089*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.440050585744933553+0.781212821300288907*%i 0.114903484931900571+1.65068260681625478*%i 0.0195633539826691495+5.82151760596473089*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.419607575907496144-0.792380888474382039*%i -1.32691890090194864-0.988555567342760066*%i -4.88806802770029858-3.16184138089665856*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3 4 5];
yref=[0.339058958525936538+0.324674424791800087*%i 0.36412814585207276+0.215903594603614996*%i 0.364831230613667068+0.146267162693192898*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.339058958525936538-0.324674424791800087*%i 0.36412814585207276-0.215903594603614996*%i 0.364831230613667068-0.146267162693192898*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.289847767402387269-0.369273247341898037*%i -0.401406418855069447+0.134449082058521574*%i -0.0367703086914941552+0.391335986221727217*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[3
4
5];
yref=[ 0.339058958525936538+0.324674424791800087*%i 0.486091260585891194-0.16040039348492377*%i 0.309062722255251721-0.538541616105031817*%i 
-0.0660433280235491887+0.397925710557099965*%i 0.36412814585207276+0.215903594603615023*%i 0.430171473875621879-0.182022115953484942*%i 
 -0.327579137591465286+0.147863143391226859*%i 0.0465651162777521929+0.367662882605524655*%i 0.364831230613667068+0.146267162693192898*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.339058958525936538-0.324674424791800087*%i 0.486091260585891194+0.16040039348492377*%i 0.309062722255251721+0.538541616105031817*%i 
-0.0660433280235491887-0.397925710557099965*%i 0.36412814585207276-0.215903594603615023*%i 0.430171473875621879+0.182022115953484942*%i 
 -0.327579137591465286-0.147863143391226859*%i 0.0465651162777521929-0.367662882605524655*%i 0.364831230613667068-0.146267162693192898*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.289847767402387269-0.369273247341898037*%i -0.503862405464482466+0.0901979833901215833*%i -0.381968773216922741+0.489537225195393555*%i 
-0.257982370633597746-0.310083357729930509*%i -0.401406418855069447+0.134449082058521546*%i -0.143424048221471756+0.444532439788452083*%i 
-0.234711371607197739-0.272180404505854456*%i -0.339352100373364829+0.148944477144840853*%i -0.0367703086914941552+0.391335986221727217*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1 2 3];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.0825704304932578653+0.284594371868072016*%i 0.265594911883436868-0.140744947159810785*%i -0.228101889059524665-0.207473852876394915*%i 
 0.270786268276835496-0.0534845083974161278*%i -0.00468434063869100758-0.278956274125194581*%i -0.273016906676212145-0.0793518126145812824*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.247711291479773887-0.284594371868071905*%i -0.796784735650310605+0.140744947159811146*%i 0.684305667178574106+0.207473852876394582*%i 
 0.270786268276835496+0.0534845083974161278*%i -0.00468434063869100758+0.278956274125194581*%i -0.273016906676212145+0.0793518126145812824*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.198591028778410006+0.219939618485522376*%i 0.259418169105827268+0.15182888693252336*%i 0.056444086802614292-0.303133529133480351*%i 
-0.186324039282828008-0.203639750812897008*%i -0.235963202326076427+0.148862060542816449*%i 0.0739606096037440097+0.274526446309476313*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[0];
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan %nan %nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[9.99999999999999955e-08];
yref=[-7.45058059692382812e-09-168658652.388109088*%i 0.25-4047807657314589*%i 33554432-1.78103536921841748e+23*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-7.45058059692382812e-09+168658652.388109088*%i 0.25+4047807657314589*%i 33554432+1.78103536921841748e+23*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-16.8658652380108833-168658652.388108224*%i -404780765.5-4047807657314569*%i -17810353664557056-1.78103536921840842e+23*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[1];
yref=[0.351883806529722065-0.901214954842308846*%i 0.0829767227596750478-2.02168904229560242*%i 0.0132137736128492556-7.99421683125834193*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.351883806529722065+0.901214954842308846*%i 0.0829767227596750478+2.02168904229560242*%i 0.0132137736128492556+7.99421683125834193*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.56822260350909426-0.783028531402667483*%i -1.65636015475537968-1.16214575591738067*%i -6.71976207741457632-4.33041279463380935*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3 4 5];
yref=[0.412044162415464765+0.236105148830688782*%i 0.406986020132752646+0.137707238974328822*%i 0.391959608420343553+0.0774312728572489062*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.412044162415464765-0.236105148830688782*%i 0.406986020132752646-0.137707238974328822*%i 0.391959608420343553-0.0774312728572489062*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.374601468553362349-0.291890001272204935*%i -0.370240997918180659+0.217996577289598981*%i 0.0369333919769440355+0.397823907283612055*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[3
4
5];
yref=[ 0.412044162415464765+0.236105148830688782*%i 0.463422297657139992-0.249464037123650451*%i 0.267641874148340619-0.601985736612042799*%i 
0.0388438196375475442+0.404200660729673644*%i 0.406986020132752646+0.137707238974328822*%i 0.408840802508480261-0.25272269785791196*%i 
-0.277293686932808758+0.231079618553641175*%i 0.130302183508562208+0.350580558421466015*%i 0.391959608420343553+0.0774312728572489062*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.412044162415464765-0.236105148830688782*%i 0.463422297657139992+0.249464037123650451*%i 0.267641874148340619+0.601985736612042799*%i 
0.0388438196375475442-0.404200660729673644*%i 0.406986020132752646-0.137707238974328822*%i 0.408840802508480261+0.25272269785791196*%i 
-0.277293686932808758-0.231079618553641175*%i 0.130302183508562208-0.350580558421466015*%i 0.391959608420343553-0.0774312728572489062*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.374601468553362349-0.291890001272204935*%i -0.493988964367443439+0.181569366543571309*%i -0.349915679185554551+0.558191738869442844*%i 
-0.331290083561390059-0.234806083805821214*%i -0.370240997918180659+0.217996577289598981*%i -0.075975014148608605+0.474602318824380143*%i 
 -0.3002455888615011-0.200355097995776388*%i -0.299218405550633115+0.224396374190722392*%i 0.0369333919769440355+0.397823907283612055*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[1.19999999999999996 2.20000000000000018 3.20000000000000018];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[0.174095089182458529+0.240546076055273117*%i 0.197117350906682559-0.228566945221770845*%i -0.29290554726319884-0.10277969811338393*%i 
0.244808700524773382-0.12841584805211595*%i -0.0775662890440067115-0.268892924189574611*%i -0.285438661452586284-0.0124328265233755314*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.173215606457922-0.239907094453251313*%i -0.672527395792539839-0.116838670628740482*%i 0.578574584743836495+0.310330402777423575*%i 
0.244808700524773382+0.12841584805211595*%i -0.0775662890440067115+0.268892924189574611*%i -0.285438661452586284+0.0124328265233755314*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.112981679720558184+0.274602721819283191*%i 0.29808070707952472+0.0473918826746817651*%i -0.0666834039986073102-0.303167692198543615*%i 
-0.236870424138133084-0.142528355256746092*%i -0.189516305562587112+0.205921110625372272*%i 0.1375999783672541+0.250391794155750469*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[0];
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[9.99999999999999955e-08];
yref=[ 0.999999999999997446-10.3349026794206473*%i 
5.03898043091051198e-08-6366197.72367634624*%i 
1.27222187258540667e-15-127323954473516.594*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.999999999999997446+10.3349026794206473*%i 
5.03898043091051198e-08+6366197.72367634624*%i 
1.27222187258540667e-15+127323954473516.594*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.999998966509724529-10.3349027794205952*%i 
-0.636619721977829234-6366197.72367631458*%i 
 -12732395.4473516364-127323954473515.953*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[1];
yref=[0.765197686557966383+0.0882569642156769973*%i 
0.440050585744933553-0.781212821300288907*%i 
0.114903484931900571-1.65068260681625478*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.765197686557966383-0.0882569642156769973*%i 
0.440050585744933553+0.781212821300288907*%i 
0.114903484931900571+1.65068260681625478*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.487703749086956295-0.596206209606004012*%i 
-0.419607575907496144-0.792380888474382039*%i 
 -1.32691890090194864-0.988555567342760066*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3 4 5];
yref=[-0.260051954901933502+0.376850010012790504*%i 0.339058958525936538+0.324674424791800087*%i 0.486091260585891194-0.160400393484923798*%i 
-0.397149809863847292-0.0169407393250650198*%i -0.066043328023549161+0.397925710557099965*%i 0.36412814585207276+0.215903594603614996*%i 
-0.177596771314338348-0.308517625249033867*%i -0.327579137591465286+0.147863143391226887*%i 0.0465651162777522137+0.367662882605524655*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.260051954901933502-0.376850010012790504*%i 0.339058958525936538-0.324674424791800087*%i 0.486091260585891194+0.160400393484923798*%i 
-0.397149809863847292+0.0169407393250650198*%i -0.066043328023549161-0.397925710557099965*%i 0.36412814585207276-0.215903594603614996*%i 
-0.177596771314338348+0.308517625249033867*%i -0.327579137591465286-0.147863143391226887*%i 0.0465651162777522137-0.367662882605524655*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.31063056052955762-0.336380148284720293*%i -0.289847767402387269-0.369273247341898037*%i -0.503862405464482466+0.090197983390121611*%i 
0.272415233538270574-0.289490760923486856*%i -0.257982370633597746-0.310083357729930509*%i -0.401406418855069447+0.134449082058521574*%i 
0.245467551730485706-0.257816638947182653*%i -0.234711371607197766-0.272180404505854456*%i -0.339352100373364829+0.148944477144840881*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.288216947635014376+0.0627738863740376352*%i 0.0825704304932578792+0.284594371868072016*%i 0.265594911883436868-0.140744947159810813*%i 
0.0691572616569851861+0.266221867363905018*%i 0.270786268276835496-0.0534845083974161417*%i -0.00468434063869102493-0.278956274125194581*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.864650842905043127-0.0627738863740379682*%i -0.24771129147977386-0.284594371868071905*%i -0.796784735650310605+0.14074494715981109*%i 
0.0691572616569851861-0.266221867363905018*%i 0.270786268276835496+0.0534845083974161417*%i -0.00468434063869102493+0.278956274125194581*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.205009668070646411-0.212086316654584245*%i -0.198591028778410006+0.219939618485522376*%i 0.259418169105827268+0.151828886932523333*%i 
 0.191600335830164975-0.197347715498268128*%i -0.186324039282828008-0.203639750812897008*%i -0.235963202326076427+0.148862060542816477*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[3
4
5];
yref=[ -0.260051954901933502+0.376850010012790504*%i 
-0.0660433280235491887+0.397925710557099965*%i 
 0.0465651162777522137+0.367662882605524655*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.260051954901933502-0.376850010012790504*%i 
-0.0660433280235491887-0.397925710557099965*%i 
 0.0465651162777522137-0.367662882605524655*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.31063056052955762-0.336380148284720293*%i 
-0.257982370633597746-0.310083357729930509*%i 
-0.339352100373364829+0.148944477144840881*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0
1
2];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.282580089296005532+0.0611426719248229084*%i 0.0805588566675057294+0.279108983487138917*%i 0.260718835711755859-0.13767078042426989*%i 
0.0680949286455164587+0.260860299794333839*%i 0.265388401248268402-0.0527501414166842847*%i -0.00493747580632844518-0.273570232162209104*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.859124750279884219-0.0578395374887053712*%i -0.245747300872034974-0.268032077903665344*%i -0.791998414023906472+0.131456891260273934*%i 
0.0702343630487119036-0.271692474123097438*%i 0.276292676347178967+0.05422698542193536*%i -0.00442002466557511048+0.284446960322645992*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.204710539394216295-0.212355593630163458*%i -0.198923241476530482+0.219693383394633845*%i 0.259374551315559143+0.152315389993061961*%i 
 0.191359168939230689-0.197567749205550591*%i -0.186588090699604608-0.203436398574806665*%i -0.235899979077726946+0.149236560997593054*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[0];
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[9.99999999999999955e-08];
yref=[ 0.722522753107867954-10.5435018262277929*%i 
3.59141267836093903e-08-8811068.85048608482*%i 
 0.0009765625-179745804549905.625*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.722522753107867954+10.5435018262277929*%i 
3.59141267836093903e-08+8811068.85048608482*%i 
 0.0009765625+179745804549905.625*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.722521698757681685-10.5435018984800166*%i 
-0.881106849177740514-8811068.85048604198*%i 
 -17974580.4541015625-179745804549904.75*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[1];
yref=[0.767624213200681527+0.0643040307807657419*%i 
0.430847058235354241-0.793245652497184595*%i 
0.111303785599441013-1.68252516187502232*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.767624213200681527-0.0643040307807657419*%i 
0.430847058235354241+0.793245652497184595*%i 
0.111303785599441013+1.68252516187502232*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.468859108540752967-0.61118988653690054*%i 
-0.434705541360321801-0.791137753558994627*%i 
 -1.3556584129158098-1.00273113072344833*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3 4 5];
yref=[-0.248113342531625036+0.384820425921874987*%i 0.34741032197772298+0.316452158174697407*%i 0.484352361476476645-0.169632958363080733*%i 
-0.397488017750936229-0.00447693217669133808*%i -0.0555197528009769292+0.399776541248366868*%i 0.369172943822437927+0.208362968213358424*%i 
-0.187188738237360874-0.302795423995985136*%i -0.323527150348925874+0.15685459545204769*%i 0.055189660894999118+0.366792098940420641*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.248113342531625036-0.384820425921874987*%i 0.34741032197772298-0.316452158174697407*%i 0.484352361476476645+0.169632958363080733*%i 
-0.397488017750936229+0.00447693217669133808*%i -0.0555197528009769292-0.399776541248366868*%i 0.369172943822437927-0.208362968213358424*%i 
-0.187188738237360874+0.302795423995985136*%i -0.323527150348925874-0.15685459545204769*%i 0.055189660894999118-0.366792098940420641*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.299936209020461475-0.345955577303420303*%i -0.299275880887315104-0.36231180956354514*%i -0.503443808023835704+0.0995835468002096852*%i 
0.263203660615266066-0.297893605530577366*%i -0.266261751732053742-0.303328873416572331*%i -0.398997153998613463+0.143195880088125477*%i 
0.237259515744153937-0.265391436758334764*%i -0.242184097696100997-0.265744320636297771*%i -0.336070627604163175+0.156967753938725224*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ -0.2861015270808977+0.07180391829547704*%i 0.0922605432719850876+0.281660571010428407*%i 0.260319128687082679-0.150514543618939234*%i 
0.0774792372615422525+0.26392041753001122*%i 0.269158266698861615-0.0613287659781691918*%i -0.0121122296346758626-0.278814546410423747*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.865048002509834491-0.0353796934361930923*%i -0.240752697743061989-0.291002905498753572*%i -0.797769166428211829+0.116701053328995441*%i 
0.0774792372615422525-0.26392041753001122*%i 0.269158266698861615+0.0613287659781691918*%i -0.0121122296346758626+0.278814546410423747*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.211576262708756763-0.205536788772230028*%i -0.190998266617662588+0.226637038578893113*%i 0.26495112077725419+0.14220260264881332*%i 
 0.185312011803817039-0.203264549976300057*%i -0.192182330497776832-0.198175028480340659*%i -0.231984863496134286+0.155136328773931631*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[3
4
5];
yref=[ -0.248113342531625036+0.384820425921874987*%i 
-0.0555197528009769431+0.399776541248366868*%i 
 0.0551896608949991249+0.366792098940420641*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.248113342531625036-0.384820425921874987*%i 
-0.0555197528009769431-0.399776541248366868*%i 
 0.0551896608949991249-0.366792098940420641*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.299936209020461475-0.345955577303420303*%i 
-0.266261751732053742-0.303328873416572331*%i 
-0.336070627604163175+0.156967753938725224*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[0.0200000000000000004
 1.02000000000000002
 2.02000000000000002];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.280518747912432531+0.0699962983078473294*%i 0.0900627485375180697+0.276248225205322884*%i 0.255562216836810185-0.147262806532555718*%i 
0.0762491476344531877+0.258594841647395546*%i 0.263784667726966349-0.0604384587417038308*%i -0.0122224672719179299-0.273425197533148701*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.859392120978805685-0.0306266274001191323*%i -0.239301736230959433-0.274428712544276476*%i -0.792729368128768042+0.107498932694273241*%i 
0.0787275103035753876-0.269354514879212581*%i 0.274640078092432294+0.0622303207195611732*%i -0.0119936004153480373+0.284308702506610222*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.211285760234088904-0.205815354225449693*%i -0.191340413986076152+0.226403734315470978*%i 0.264929169130263764+0.142693333701389785*%i 
 0.185064066088280632-0.203476918530006629*%i -0.192441625422114404-0.197965053817515446*%i -0.231914093404297944+0.155511238858410061*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[0];
yref=[%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[9.99999999999999955e-08];
yref=[-5.03898043091051198e-08+6366197.72367634624*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-5.03898043091051198e-08-6366197.72367634624*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.636619721977829234+6366197.72367631458*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[1];
yref=[-0.440050585744933553+0.781212821300288907*%i];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.440050585744933553-0.781212821300288907*%i];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.419607575907496144+0.792380888474382039*%i];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3 4 5];
yref=[-0.339058958525936538-0.324674424791800087*%i 0.0660433280235491887-0.397925710557099965*%i 0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538+0.324674424791800087*%i 0.0660433280235491887+0.397925710557099965*%i 0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.289847767402387269+0.369273247341898037*%i 0.257982370633597746+0.310083357729930509*%i 0.234711371607197739+0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.0825704304932578653-0.284594371868072016*%i -0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.247711291479773887+0.284594371868071905*%i -0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198591028778410006-0.219939618485522376*%i 0.186324039282828008+0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[3
4
5];
yref=[-0.339058958525936538-0.324674424791800087*%i 
0.0660433280235491887-0.397925710557099965*%i 
 0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538+0.324674424791800087*%i 
0.0660433280235491887+0.397925710557099965*%i 
 0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.289847767402387269+0.369273247341898037*%i 
0.257982370633597746+0.310083357729930509*%i 
0.234711371607197739+0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.0825704304932578653-0.284594371868072016*%i 
 -0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.247711291479773887+0.284594371868071905*%i 
-0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198591028778410006-0.219939618485522376*%i 
0.186324039282828008+0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.0805588566675057155-0.279108983487138917*%i -0.265388401248268402+0.0527501414166842708*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[0.245747300872035002+0.268032077903665344*%i -0.276292676347178967-0.0542269854219353462*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198923241476530482-0.219693383394633845*%i 0.186588090699604608+0.203436398574806665*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[0];
yref=[%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[9.99999999999999955e-08];
yref=[-5.03898043091051198e-08+6366197.72367634624*%i 
 -25231325220.2017288-1.0872797214348254e-06*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-5.03898043091051198e-08-6366197.72367634624*%i 
 -25231325220.2017288+1.0872797214348254e-06*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.636619721977829234+6366197.72367631458*%i 
-25231325220.2016029+2523.1325234030769*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[1];
yref=[-0.440050585744933553+0.781212821300288907*%i 
 -1.10249557516017949-0.240297839123426921*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.440050585744933553-0.781212821300288907*%i 
 -1.10249557516017949+0.240297839123426921*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.419607575907496144+0.792380888474382039*%i 
-0.797884560802865517+0.797884560802865628*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[3 4 5];
yref=[-0.339058958525936538-0.324674424791800087*%i 0.0870080907208351517-0.477718215087091835*%i 
0.0660433280235491887-0.397925710557099965*%i 0.367112032460934101-0.185285948354268981*%i 
 0.327579137591465286-0.147863143391226859*%i 0.3219244429611402+0.169651306144740777*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.339058958525936538+0.324674424791800087*%i 0.0870080907208351517+0.477718215087091835*%i 
0.0660433280235491887+0.397925710557099965*%i 0.367112032460934101+0.185285948354268981*%i 
 0.327579137591465286+0.147863143391226859*%i 0.3219244429611402-0.169651306144740777*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.289847767402387269+0.369273247341898037*%i -0.153552955320593432+0.460658865961780795*%i 
0.257982370633597746+0.310083357729930509*%i -0.099735570100358148+0.398942280401432703*%i 
0.234711371607197739+0.272180404505854456*%i -0.0713649646461108761+0.356824823230554311*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982 8.40000000000000036];
yref=[-0.0825704304932578653-0.284594371868072016*%i 0.120953010973630551-0.272424375376841443*%i 
 -0.270786268276835496+0.0534845083974161278*%i -0.218249100772301557-0.170966347821113224*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.247711291479773887+0.284594371868071905*%i -0.12095301097362865-0.27242437537684111*%i 
-0.270786268276835496-0.0534845083974161278*%i -0.218249100772301557+0.170966347821113224*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198591028778410006-0.219939618485522376*%i 0.295310324905105781-0.0404534691650830225*%i 
0.186324039282828008+0.203639750812897008*%i -0.0327733723655391565+0.275296327870529045*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982
 8.40000000000000036];
yref=[-0.0825704304932578653-0.284594371868072016*%i 
 -0.218249100772301557-0.170966347821113224*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.247711291479773887+0.284594371868071905*%i 
-0.218249100772301557+0.170966347821113224*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.198591028778410006-0.219939618485522376*%i 
-0.0327733723655391565+0.275296327870529045*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1
-1.5];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[-0.0805588566675057155-0.279108983487138917*%i 0.118980970251344659-0.266959004819083301*%i 
 -0.265388401248268402+0.0527501414166842708*%i -0.214192031331076199-0.167365441205606091*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.245747300872035002+0.268032077903665344*%i -0.122956267664942304-0.277999563638954672*%i 
-0.276292676347178967-0.0542269854219353462*%i -0.222382024788788296+0.174643212333444514*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.198923241476530482-0.219693383394633845*%i 0.295475738987752923-0.040048367037329724*%i 
0.186588090699604608+0.203436398574806665*%i -0.032445291449234602+0.275412789424954285*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[0];
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[ -311843.447284119495+5.09295817894065707e+21*%i 
 1.27222187258540667e-15-127323954473516.594*%i 
-5.03898043091051198e-08+6366197.72367634624*%i 
 0.999999999999997446-10.3349026794206473*%i 
 5.03898043091051198e-08-6366197.72367634624*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -311843.447284119495-5.09295817894065707e+21*%i 
 1.27222187258540667e-15+127323954473516.594*%i 
-5.03898043091051198e-08-6366197.72367634624*%i 
 0.999999999999997446+10.3349026794206473*%i 
 5.03898043091051198e-08+6366197.72367634624*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 509295817582221.438+5.09295817894063191e+21*%i 
 -12732395.4473516364-127323954473515.953*%i 
 0.636619721977829234+6366197.72367631458*%i 
 0.999998966509724529-10.3349027794205952*%i 
-0.636619721977829234-6366197.72367631458*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[1];
yref=[-0.0195633539826691495+5.82151760596473089*%i 
 0.114903484931900571-1.65068260681625478*%i 
 -0.440050585744933553+0.781212821300288907*%i 
 0.765197686557966383+0.0882569642156769973*%i 
 0.440050585744933553-0.781212821300288907*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.0195633539826691495-5.82151760596473089*%i 
 0.114903484931900571+1.65068260681625478*%i 
 -0.440050585744933553-0.781212821300288907*%i 
 0.765197686557966383-0.0882569642156769973*%i 
 0.440050585744933553+0.781212821300288907*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 4.88806802770029858+3.16184138089665856*%i 
 -1.32691890090194864-0.988555567342760066*%i 
 0.419607575907496144+0.792380888474382039*%i 
 0.487703749086956295-0.596206209606004012*%i 
-0.419607575907496144-0.792380888474382039*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[3 4 5];
yref=[-0.309062722255251721+0.538541616105031817*%i 0.486091260585891194-0.160400393484923798*%i -0.339058958525936538-0.324674424791800087*%i -0.260051954901933502+0.376850010012790504*%i 0.339058958525936538+0.324674424791800087*%i 
-0.430171473875621879+0.182022115953484942*%i 0.36412814585207276+0.215903594603614996*%i 0.0660433280235491887-0.397925710557099965*%i -0.397149809863847292-0.0169407393250650198*%i -0.0660433280235491887+0.397925710557099965*%i 
-0.364831230613667068-0.146267162693192898*%i 0.0465651162777522137+0.367662882605524655*%i 0.327579137591465286-0.147863143391226859*%i -0.177596771314338348-0.308517625249033867*%i -0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.309062722255251721-0.538541616105031817*%i 0.486091260585891194+0.160400393484923798*%i -0.339058958525936538+0.324674424791800087*%i -0.260051954901933502-0.376850010012790504*%i 0.339058958525936538-0.324674424791800087*%i 
-0.430171473875621879-0.182022115953484942*%i 0.36412814585207276-0.215903594603614996*%i 0.0660433280235491887+0.397925710557099965*%i -0.397149809863847292+0.0169407393250650198*%i -0.0660433280235491887-0.397925710557099965*%i 
-0.364831230613667068+0.146267162693192898*%i 0.0465651162777522137-0.367662882605524655*%i 0.327579137591465286+0.147863143391226859*%i -0.177596771314338348+0.308517625249033867*%i -0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.381968773216922741-0.489537225195393555*%i -0.503862405464482466+0.090197983390121611*%i 0.289847767402387269+0.369273247341898037*%i 0.31063056052955762-0.336380148284720293*%i -0.289847767402387269-0.369273247341898037*%i 
 0.143424048221471756-0.444532439788452083*%i -0.401406418855069447+0.134449082058521574*%i 0.257982370633597746+0.310083357729930509*%i 0.272415233538270574-0.289490760923486856*%i -0.257982370633597746-0.310083357729930509*%i 
0.0367703086914941552-0.391335986221727217*%i -0.339352100373364829+0.148944477144840881*%i 0.234711371607197739+0.272180404505854456*%i 0.245467551730485706-0.257816638947182653*%i -0.234711371607197739-0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.228101889059524665+0.207473852876394915*%i 0.265594911883436868-0.140744947159810813*%i -0.0825704304932578653-0.284594371868072016*%i -0.288216947635014376+0.0627738863740376352*%i 0.0825704304932578653+0.284594371868072016*%i 
0.273016906676212145+0.0793518126145812824*%i -0.00468434063869102493-0.278956274125194581*%i -0.270786268276835496+0.0534845083974161278*%i 0.0691572616569851861+0.266221867363905018*%i 0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.684305667178574106-0.207473852876394582*%i -0.796784735650310605+0.14074494715981109*%i 0.247711291479773887+0.284594371868071905*%i 0.864650842905043127-0.0627738863740379682*%i -0.247711291479773887-0.284594371868071905*%i 
 0.273016906676212145-0.0793518126145812824*%i -0.00468434063869102493+0.278956274125194581*%i -0.270786268276835496-0.0534845083974161278*%i 0.0691572616569851861-0.266221867363905018*%i 0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ -0.056444086802614292+0.303133529133480351*%i 0.259418169105827268+0.151828886932523333*%i 0.198591028778410006-0.219939618485522376*%i -0.205009668070646411-0.212086316654584245*%i -0.198591028778410006+0.219939618485522376*%i 
-0.0739606096037440097-0.274526446309476313*%i -0.235963202326076427+0.148862060542816477*%i 0.186324039282828008+0.203639750812897008*%i 0.191600335830164975-0.197347715498268128*%i -0.186324039282828008-0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-3
-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.223624092905500088+0.204064898970382769*%i 0.260718835711755859-0.13767078042426989*%i -0.0805588566675057155-0.279108983487138917*%i -0.282580089296005532+0.0611426719248229084*%i 0.0805588566675057155+0.279108983487138917*%i 
0.268049735447983994+0.077515061198177887*%i -0.00493747580632844518-0.273570232162209104*%i -0.265388401248268402+0.0527501414166842708*%i 0.0680949286455164587+0.260860299794333839*%i 0.265388401248268402-0.0527501414166842708*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.679913121372516915-0.197190400008995986*%i -0.791998414023906472+0.131456891260273934*%i 0.245747300872035002+0.268032077903665344*%i 0.859124750279884219-0.0578395374887053712*%i -0.245747300872035002-0.268032077903665344*%i 
 0.278074937671342448-0.0812281915443821972*%i -0.00442002466557511048+0.284446960322645992*%i -0.276292676347178967-0.0542269854219353462*%i 0.0702343630487119036-0.271692474123097438*%i 0.276292676347178967+0.0542269854219353462*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.0570299235953570793+0.303542619878177933*%i 0.259374551315559143+0.152315389993061961*%i 0.198923241476530482-0.219693383394633845*%i -0.204710539394216295-0.212355593630163458*%i -0.198923241476530482+0.219693383394633845*%i 
-0.0744246056267901385-0.274768483538119612*%i -0.235899979077726946+0.149236560997593054*%i 0.186588090699604608+0.203436398574806665*%i 0.191359168939230689-0.197567749205550591*%i -0.186588090699604608-0.203436398574806665*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[0];
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[9.99999999999999955e-08];
yref=[ 1.27222187258540667e-15-127323954473516.594*%i 
-5.03898043091051198e-08+6366197.72367634624*%i 
 0.999999999999997446-10.3349026794206473*%i 
 5.03898043091051198e-08-6366197.72367634624*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 1.27222187258540667e-15+127323954473516.594*%i 
-5.03898043091051198e-08-6366197.72367634624*%i 
 0.999999999999997446+10.3349026794206473*%i 
 5.03898043091051198e-08+6366197.72367634624*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ -12732395.4473516364-127323954473515.953*%i 
 0.636619721977829234+6366197.72367631458*%i 
 0.999998966509724529-10.3349027794205952*%i 
-0.636619721977829234-6366197.72367631458*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[1];
yref=[ 0.114903484931900571-1.65068260681625478*%i 
-0.440050585744933553+0.781212821300288907*%i 
 0.765197686557966383+0.0882569642156769973*%i 
 0.440050585744933553-0.781212821300288907*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.114903484931900571+1.65068260681625478*%i 
-0.440050585744933553-0.781212821300288907*%i 
 0.765197686557966383-0.0882569642156769973*%i 
 0.440050585744933553+0.781212821300288907*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ -1.32691890090194864-0.988555567342760066*%i 
 0.419607575907496144+0.792380888474382039*%i 
 0.487703749086956295-0.596206209606004012*%i 
-0.419607575907496144-0.792380888474382039*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[3 4 5];
yref=[ 0.486091260585891194-0.160400393484923798*%i -0.339058958525936538-0.324674424791800087*%i -0.260051954901933502+0.376850010012790504*%i 0.339058958525936538+0.324674424791800087*%i 
 0.36412814585207276+0.215903594603614996*%i 0.0660433280235491887-0.397925710557099965*%i -0.397149809863847292-0.0169407393250650198*%i -0.0660433280235491887+0.397925710557099965*%i 
0.0465651162777522137+0.367662882605524655*%i 0.327579137591465286-0.147863143391226859*%i -0.177596771314338348-0.308517625249033867*%i -0.327579137591465286+0.147863143391226859*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.486091260585891194+0.160400393484923798*%i -0.339058958525936538+0.324674424791800087*%i -0.260051954901933502-0.376850010012790504*%i 0.339058958525936538-0.324674424791800087*%i 
 0.36412814585207276-0.215903594603614996*%i 0.0660433280235491887+0.397925710557099965*%i -0.397149809863847292+0.0169407393250650198*%i -0.0660433280235491887-0.397925710557099965*%i 
0.0465651162777522137-0.367662882605524655*%i 0.327579137591465286+0.147863143391226859*%i -0.177596771314338348+0.308517625249033867*%i -0.327579137591465286-0.147863143391226859*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.503862405464482466+0.090197983390121611*%i 0.289847767402387269+0.369273247341898037*%i 0.31063056052955762-0.336380148284720293*%i -0.289847767402387269-0.369273247341898037*%i 
-0.401406418855069447+0.134449082058521574*%i 0.257982370633597746+0.310083357729930509*%i 0.272415233538270574-0.289490760923486856*%i -0.257982370633597746-0.310083357729930509*%i 
-0.339352100373364829+0.148944477144840881*%i 0.234711371607197739+0.272180404505854456*%i 0.245467551730485706-0.257816638947182653*%i -0.234711371607197739-0.272180404505854456*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982 8.40000000000000036];
yref=[ 0.265594911883436868-0.140744947159810813*%i -0.0825704304932578653-0.284594371868072016*%i -0.288216947635014376+0.0627738863740376352*%i 0.0825704304932578653+0.284594371868072016*%i 
-0.00468434063869102493-0.278956274125194581*%i -0.270786268276835496+0.0534845083974161278*%i 0.0691572616569851861+0.266221867363905018*%i 0.270786268276835496-0.0534845083974161278*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.796784735650310605+0.14074494715981109*%i 0.247711291479773887+0.284594371868071905*%i 0.864650842905043127-0.0627738863740379682*%i -0.247711291479773887-0.284594371868071905*%i 
-0.00468434063869102493+0.278956274125194581*%i -0.270786268276835496-0.0534845083974161278*%i 0.0691572616569851861-0.266221867363905018*%i 0.270786268276835496+0.0534845083974161278*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.259418169105827268+0.151828886932523333*%i 0.198591028778410006-0.219939618485522376*%i -0.205009668070646411-0.212086316654584245*%i -0.198591028778410006+0.219939618485522376*%i 
-0.235963202326076427+0.148862060542816477*%i 0.186324039282828008+0.203639750812897008*%i 0.191600335830164975-0.197347715498268128*%i -0.186324039282828008-0.203639750812897008*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[-2
-1
 0
 1];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[ 0.260718835711755859-0.13767078042426989*%i -0.0805588566675057155-0.279108983487138917*%i -0.282580089296005532+0.0611426719248229084*%i 0.0805588566675057155+0.279108983487138917*%i 
-0.00493747580632844518-0.273570232162209104*%i -0.265388401248268402+0.0527501414166842708*%i 0.0680949286455164587+0.260860299794333839*%i 0.265388401248268402-0.0527501414166842708*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -0.791998414023906472+0.131456891260273934*%i 0.245747300872035002+0.268032077903665344*%i 0.859124750279884219-0.0578395374887053712*%i -0.245747300872035002-0.268032077903665344*%i 
-0.00442002466557511048+0.284446960322645992*%i -0.276292676347178967-0.0542269854219353462*%i 0.0702343630487119036-0.271692474123097438*%i 0.276292676347178967+0.0542269854219353462*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.259374551315559143+0.152315389993061961*%i 0.198923241476530482-0.219693383394633845*%i -0.204710539394216295-0.212355593630163458*%i -0.198923241476530482+0.219693383394633845*%i 
-0.235899979077726946+0.149236560997593054*%i 0.186588090699604608+0.203436398574806665*%i 0.191359168939230689-0.197567749205550591*%i -0.186588090699604608-0.203436398574806665*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ -716418914.617646098+520508809.337161541*%i 
 119.403152436272933-86.7425820843251927*%i 
8.52879747981205583e-06-53316.8312102425552*%i 
 0.0001220703125-746435636856.653198*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ -716418914.617646098-520508809.337161541*%i 
 119.403152436272933+86.7425820843251927*%i 
8.52879747981205583e-06+53316.8312102425552*%i 
 0.0001220703125+746435636856.653198*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ -716418862.566761613+520508880.979050338*%i 
 119.403143762014125-86.7425940246399847*%i 
-0.00532315432428731583-53316.8312102422933*%i 
 -74643.5635986328125-746435636856.649536*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[-0.96267128684022385+0.314183689901754326*%i 
0.633870726369384796+0.454431262899762989*%i 
0.582348851018592462-0.586842447641611864*%i 
0.181417665056644584-1.27601068959802011*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.96267128684022385-0.314183689901754326*%i 
0.633870726369384796-0.454431262899762989*%i 
0.582348851018592462+0.586842447641611864*%i 
0.181417665056644584+1.27601068959802011*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.255757057120614473+0.97981412790380662*%i 
 0.7248725373994509-0.287853565155630209*%i 
-0.179166465319056278-0.807101988810427939*%i 
-0.975705588846130234-0.842089219178969395*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[-0.106536302179580572-0.46608061111318333*%i -0.406752056449066923+0.212390924829804678*%i 0.187886713469393868+0.423602426147222433*%i 0.494432522734784108-0.014709792627767504*%i 
 0.268869311811565981-0.306380088504755344*%i -0.344459534063007222-0.19942551345146825*%i -0.21720038170211492+0.336293915522475506*%i 0.268439400467266942+0.317128383884334675*%i 
 0.35944584577841987+0.0416545814756734967*%i -0.0150494093195696621-0.355966921924183777*%i -0.3576399166600715+0.00106144915522857208*%i -0.0850897673452503944+0.356264127687647869*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.106536302179580572+0.46608061111318333*%i -0.406752056449066923-0.212390924829804678*%i 0.187886713469393868-0.423602426147222433*%i 0.494432522734784108+0.014709792627767504*%i 
 0.268869311811565981+0.306380088504755344*%i -0.344459534063007222+0.19942551345146825*%i -0.21720038170211492-0.336293915522475506*%i 0.268439400467266942-0.317128383884334675*%i 
 0.35944584577841987-0.0416545814756734967*%i -0.0150494093195696621+0.355966921924183777*%i -0.3576399166600715-0.00106144915522857208*%i -0.0850897673452503944-0.356264127687647869*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[0.0396968401765022405+0.476450711635252655*%i 0.432654092885201846-0.152864568443076054*%i -0.126227658753542527-0.4458777979466374*%i -0.491560333636854974-0.0552117372653547489*%i 
0.0561245049814432517+0.403744356501480606*%i 0.376079503294072581-0.130334620206487478*%i -0.112536430475554117-0.384194163470507555*%i -0.415467253960516536-0.0041333370081901577*%i 
0.0620176048412275638+0.356497176559695039*%i 0.337076374072698137-0.115405598941508536*%i -0.102466769729951307-0.342648504686714039*%i -0.365767069597084549+0.0194640176292286138*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.0420367120856716403-0.294296885430083921*%i -0.285871190821628263-0.0732023688316385257*%i -0.0655329743449836188+0.288280252375428703*%i 0.298439158504227919+0.0179157450884056269*%i 
-0.262892922068786006-0.086280619148427995*%i -0.0606892109991265527+0.268366926287592067*%i 0.267227865711580748+0.0671115529850285913*%i 0.105227188617723372-0.257181667456753915*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.208809604864427539-0.0509634500368111726*%i 0.553022915362730627-0.294500434849446491*%i -0.163355666615431105+0.0267579348437040482*%i -0.521694431354299826+0.289368776112292503*%i 
-0.262892922068786006+0.086280619148427995*%i -0.0606892109991265527-0.268366926287592067*%i 0.267227865711580748-0.0671115529850285913*%i 0.105227188617723372+0.257181667456753915*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.272395417839566834-0.119073415491575602*%i -0.0881364311870380251-0.281625449918773474*%i -0.279639508074117915+0.0959261182379777672*%i 0.141765925886183919+0.263228660119709246*%i 
0.0627819887644752439+0.269472550738063421*%i 0.260861300871524204-0.0874949665087225992*%i -0.081414938826726943-0.263222910273154698*%i -0.274430457342645373+0.0436244814631968347*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.0416209715612942399-0.288486935012754131*%i -0.28010358610171443-0.0721332902155140676*%i -0.0646267682459302079+0.282495141853438825*%i 0.292646097237778458+0.017990502767282146*%i 
-0.257841240101032931-0.0842758673723411206*%i -0.0591735817167325096+0.26311716547420122*%i 0.262023152985124297+0.0654718271887456127*%i 0.102869840386841327-0.252309232987196319*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.203155336114940382-0.0612984986078191629*%i 0.553905555294752938-0.290836180966331459*%i -0.157563702980964282+0.0375190635506771827*%i -0.523668372270335358+0.283723585718319904*%i 
-0.268042418096517854+0.0883312018516905356*%i -0.0622417085009255161-0.273720247940547168*%i 0.272534780013686639-0.0687904516700227342*%i 0.107636616697512302+0.262147089547452361*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.272634230972951086-0.118721332047866335*%i -0.087748953311749589-0.281736812085001009*%i -0.279782977722092485+0.095545296131978083*%i 0.141455761678950437+0.263560198603161933*%i 
0.0631218629428649258+0.269449807661711782*%i 0.26075102821782209-0.0878026901637817547*%i -0.0817318984576275442-0.263133877327358878*%i -0.274477351685756932+0.0439797256650979601*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[];
yref=[];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[0];
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[%nan
%nan
%nan
%nan
%nan]*(1+%i);
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[9.99999999999999955e-08];
yref=[ 18626891780058596-13533229042766080*%i 
 -716418914.617646098+520508809.337161541*%i 
 119.403152436272933-86.7425820843251927*%i 
8.52879747981205583e-06-53316.8312102425552*%i 
 0.0001220703125-746435636856.653198*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 18626891780058596+13533229042766080*%i 
 -716418914.617646098-520508809.337161541*%i 
 119.403152436272933+86.7425820843251927*%i 
8.52879747981205583e-06+53316.8312102425552*%i 
 0.0001220703125+746435636856.653198*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 18626890426735600-13533230905455192*%i 
 -716418862.566761613+520508880.979050338*%i 
 119.403143762014125-86.7425940246399847*%i 
-0.00532315432428731583-53316.8312102422933*%i 
 -74643.5635986328125-746435636856.649536*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[1];
yref=[ 1.86907461941519504-1.2713088566443258*%i 
-0.96267128684022385+0.314183689901754326*%i 
0.633870726369384796+0.454431262899762989*%i 
0.582348851018592462-0.586842447641611864*%i 
0.181417665056644584-1.27601068959802011*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 1.86907461941519504+1.2713088566443258*%i 
-0.96267128684022385-0.314183689901754326*%i 
0.633870726369384796-0.454431262899762989*%i 
0.582348851018592462+0.586842447641611864*%i 
0.181417665056644584+1.27601068959802011*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.0599041888858562466-2.2596631673942662*%i 
 -0.255757057120614473+0.97981412790380662*%i 
 0.7248725373994509-0.287853565155630209*%i 
 -0.179166465319056278-0.807101988810427939*%i 
 -0.975705588846130234-0.842089219178969395*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[3 4 5];
yref=[ 0.499083518338036936+0.191545604801620417*%i -0.106536302179580572-0.46608061111318333*%i -0.406752056449066923+0.212390924829804678*%i 0.187886713469393868+0.423602426147222433*%i 0.494432522734784108-0.014709792627767504*%i 
 0.169694481385489565+0.398572570979558949*%i 0.268869311811565981-0.306380088504755344*%i -0.344459534063007222-0.19942551345146825*%i -0.21720038170211492+0.336293915522475506*%i 0.268439400467266942+0.317128383884334675*%i 
-0.171862430485208495+0.334306539556833759*%i 0.35944584577841987+0.0416545814756734967*%i -0.0150494093195696621-0.355966921924183777*%i -0.3576399166600715+0.00106144915522857208*%i -0.0850897673452503944+0.356264127687647869*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[ 0.499083518338036936-0.191545604801620417*%i -0.106536302179580572+0.46608061111318333*%i -0.406752056449066923-0.212390924829804678*%i 0.187886713469393868-0.423602426147222433*%i 0.494432522734784108+0.014709792627767504*%i 
 0.169694481385489565-0.398572570979558949*%i 0.268869311811565981+0.306380088504755344*%i -0.344459534063007222+0.19942551345146825*%i -0.21720038170211492-0.336293915522475506*%i 0.268439400467266942-0.317128383884334675*%i 
-0.171862430485208495-0.334306539556833759*%i 0.35944584577841987-0.0416545814756734967*%i -0.0150494093195696621+0.355966921924183777*%i -0.3576399166600715-0.00106144915522857208*%i -0.0850897673452503944-0.356264127687647869*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[-0.467058021038170568-0.260059381640809106*%i 0.0396968401765022405+0.476450711635252655*%i 0.432654092885201846-0.152864568443076054*%i -0.126227658753542527-0.4458777979466374*%i -0.491560333636854974-0.0552117372653547489*%i 
-0.412560431532010941-0.132099211519474513*%i 0.0561245049814432517+0.403744356501480606*%i 0.376079503294072581-0.130334620206487478*%i -0.112536430475554117-0.384194163470507555*%i -0.415467253960516536-0.0041333370081901577*%i 
-0.369325528590136676-0.069972932869532628*%i 0.0620176048412275638+0.356497176559695039*%i 0.337076374072698137-0.115405598941508536*%i -0.102466769729951307-0.342648504686714039*%i -0.365767069597084549+0.0194640176292286138*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982 8.40000000000000036];
yref=[0.300843170468579835-0.0316156999516793158*%i 0.0420367120856716403-0.294296885430083921*%i -0.285871190821628263-0.0732023688316385257*%i -0.0655329743449836188+0.288280252375428703*%i 0.298439158504227919+0.0179157450884056269*%i 
0.142060829734702965-0.241661020360697809*%i -0.262892922068786006-0.086280619148427995*%i -0.0606892109991265527+0.268366926287592067*%i 0.267227865711580748+0.0671115529850285913*%i 0.105227188617723372-0.257181667456753915*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.478652371164440149+0.276349069082910681*%i 0.208809604864427539-0.0509634500368111726*%i 0.553022915362730627-0.294500434849446491*%i -0.163355666615431105+0.0267579348437040482*%i -0.521694431354299826+0.289368776112292503*%i 
 0.142060829734702965+0.241661020360697809*%i -0.262892922068786006+0.086280619148427995*%i -0.0606892109991265527-0.268366926287592067*%i 0.267227865711580748-0.0671115529850285913*%i 0.105227188617723372+0.257181667456753915*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.185153977266883929+0.239215740291636808*%i 0.272395417839566834-0.119073415491575602*%i -0.0881364311870380251-0.281625449918773474*%i -0.279639508074117915+0.0959261182379777672*%i 0.141765925886183919+0.263228660119709246*%i 
-0.280293821203385529+0.00408679604217940251*%i 0.0627819887644752439+0.269472550738063421*%i 0.260861300871524204-0.0874949665087225992*%i -0.081414938826726943-0.263222910273154698*%i -0.274430457342645373+0.0436244814631968347*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
alpha=[ -2.29999999999999982
 -1.30000000000000004
-0.300000000000000044
 0.699999999999999956
 1.69999999999999996];
x=[-7.29999999999999982+0.0200000000000000004*%i 8.40000000000000036+0.0200000000000000004*%i ];
yref=[0.295208883882440876-0.0305740967814102649*%i 0.0416209715612942399-0.288486935012754131*%i -0.28010358610171443-0.0721332902155140676*%i -0.0646267682459302079+0.282495141853438825*%i 0.292646097237778458+0.017990502767282146*%i 
0.139043239894831056-0.237221943806996016*%i -0.257841240101032931-0.0842758673723411206*%i -0.0591735817167325096+0.26311716547420122*%i 0.262023152985124297+0.0654718271887456127*%i 0.102869840386841327-0.252309232987196319*%i ];
y=besselh(alpha,x);
if testresult() then pause,end
yref=[-0.481489589165971232+0.269202238903625657*%i 0.203155336114940382-0.0612984986078191629*%i 0.553905555294752938-0.290836180966331459*%i -0.157563702980964282+0.0375190635506771827*%i -0.523668372270335358+0.283723585718319904*%i 
 0.145141652219097028+0.246182257025218565*%i -0.268042418096517854+0.0883312018516905356*%i -0.0622417085009255161-0.273720247940547168*%i 0.272534780013686639-0.0687904516700227342*%i 0.107636616697512302+0.262147089547452361*%i ];
y=besselh(alpha,2,x);
if testresult() then pause,end
yref=[ 0.184966673823006966+0.239718851959764251*%i 0.272634230972951086-0.118721332047866335*%i -0.087748953311749589-0.281736812085001009*%i -0.279782977722092485+0.095545296131978083*%i 0.141455761678950437+0.263560198603161933*%i 
-0.280487209938313775+0.00444855012972955599*%i 0.0631218629428649258+0.269449807661711782*%i 0.26075102821782209-0.0878026901637817547*%i -0.0817318984576275442-0.263133877327358878*%i -0.274477351685756932+0.0439797256650979601*%i ];
y=besselh(alpha,1,x,1);
if testresult() then pause,end
