/*
    siefs: a virtual filesystem for accessing Siemens mobiles
    Copyright (C) 2003  Dmitry Zakharov (dmitry-z@mail.ru)

    This program can be distributed under the terms of the GNU GPL.
    See the file COPYING.
*/

#ifndef BFB_H
#define BFB_H

#include "comm.h"

#define LINK_UNKNOWN 0
#define LINK_BFB 1
#define LINK_QWE3 2

typedef struct bfb_connection_s {

	hcomm *h;		/* file descriptor */
	int linktype;		/* bfb or qwe3 */
	int startup;		/* 1 = don't test connection */
	int timeout;
	int speed0;		/* requested baudrate */
	int speed;		/* current baudrate */
	unsigned char seq;	/* output sequence counter */
	unsigned char iseq;	/* input sequence counter */
	int buflen;
	unsigned char *buffer;	/* workspace */

} bfb_connection;

unsigned short crc16(unsigned char *buf, int len);
bfb_connection *bfb_open(char *device, int speed, int timeout);
int bfb_test(bfb_connection *b, int cnt);
int bfb_initiate(bfb_connection *b);
int bfb_send(bfb_connection *b, void *buf, int len);
int bfb_recv(bfb_connection *b, void *buf, int size);
void bfb_close(bfb_connection *b);

#endif

