/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mozilla.
 *
 * The Initial Developer of the Original Code is IBM Corporation.
 * Portions created by IBM Corporation are Copyright (C) 2003
 * IBM Corporation. All Rights Reserved.
 *
 * Contributor(s):
 *   Darin Fisher <darin@meer.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsXULAppAPI.h"
#include "plstr.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef XP_WIN
#include <windows.h>
#endif

static PRBool IsArg(const char* arg, const char* s)
{
  if (*arg == '-')
  {
    if (*++arg == '-')
      ++arg;
    return !PL_strcasecmp(arg, s);
  }

#if defined(XP_WIN) || defined(XP_OS2)
  if (*arg == '/')
    return !PL_strcasecmp(++arg, s);
#endif

  return PR_FALSE;
}

int main(int argc, char* argv[])
{
  if (argc == 1 || IsArg(argv[1], "h")
                || IsArg(argv[1], "help")
                || IsArg(argv[1], "?"))
  {
    printf("Usage: " XULRUNNER_PROGNAME " [OPTIONS] [APP-FILE [APP-OPTIONS...]]\n");
    if (argc > 1) {
      // display additional information
      printf("\n"
             "OPTIONS\n"
             "  -h, --help       show this message\n"
             "  -v, --version    show version\n"
             "\n"
             "APP-FILE\n"
             "  Application initialization file.\n"
             "\n"
             "APP-OPTIONS\n"
             "  Application specific options.\n");
    }
    return 0;
  }

  if (argc == 2 && (IsArg(argv[1], "v") || IsArg(argv[1], "version"))) {
    printf("Mozilla XULRunner %s %s (Gecko:%s)\n", APP_VERSION, BUILD_ID, MOZILLA_VERSION);
    return 0;
  }

  // fixup argv to start with -app.
  char **argv2 = NULL;
  if (argv[1][0] != '-')
  {
    argv2 = (char **) malloc(sizeof(char*) * (argc + 2));
    argv2[0] = argv[0];
    argv2[1] = "-app";
    for (int i=1; i<argc; ++i)
      argv2[i+1] = argv[i];
    argv2[argc+1] = NULL;
    argv = argv2;
    argc++;
  }

  int rv = xre_main(argc, argv, NULL);

  if (argv2)
    free(argv2);

  return rv;
}
                                                                                                                                                
#if defined( XP_WIN ) && defined( WIN32 ) && !defined(__GNUC__)
// We need WinMain in order to not be a console app.  This function is
// unused if we are a console application.
int WINAPI WinMain( HINSTANCE, HINSTANCE, LPSTR args, int )
{
  // Do the real work.
  return main( __argc, __argv );
}
#endif
