/*
 * backlight command line utility for Sharp Zaurus SL
 * Alexander Chukov <sash@cacko.biz>
 */

#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>

#define FL_IOCTL_STEP_CONTRAST		100
#define FL_IOCTL_GET_STEP_CONTRAST	101
#define FL_IOCTL_GET_STEP		102

int getfl(void)
{
    int bl;
    int fd;
    
    fd = open("/dev/fl", O_RDONLY);
    bl = ioctl(fd, FL_IOCTL_GET_STEP_CONTRAST, 0);
    close(fd);

    return bl;
}

int setfl(int l)
{
    int bl;
    int fd;
    
    fd = open("/dev/fl", O_WRONLY);
    bl = ioctl(fd, FL_IOCTL_STEP_CONTRAST, l);
    close(fd);

    return 0;
}

int main(int argc, char *argv[])
{
    int lvl;
    
    if (argc < 2) {
	printf("Usage: %s [0..6|+|-]\nwhere 0 - light off, 6 - light maximum\n", argv[0]);
	return 1;
    }
    if (*argv[1] == '+') {
	lvl = getfl();
	if (lvl < 6) setfl(lvl+1);
    } else if (*argv[1] == '-') {
	lvl = getfl();
	if (lvl > 0) setfl(lvl-1);
    } else {
	setfl(atoi(argv[1]));
    }
    return 0;
}
