#include <qvalidator.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qspinbox.h>
#include <qwidget.h>
#include <qfile.h>
#include <qdir.h>
#include <stdlib.h>
#include "config.h"
#include "usbdbase.h"
#include "usbd.h"

Usbd::Usbd(QWidget *parent, const char *name):
    usbdbase(parent, name)
{
    Config *conf = new Config("Usbd");
    conf->setGroup("Emulation");
    if (conf->readBoolEntry("Serial", false)) {
	storage_but(0);
	net_but(0);
	serial_button->setChecked(true);
    } else serial_button->setChecked(false);
    if (conf->readBoolEntry("Network", true)) {
	storage_but(0);
	net_but(1);
	net_button->setChecked(true);
    } else net_button->setChecked(false);
    if (conf->readBoolEntry("Storage", false)) {
	storage_but(1);
	net_but(0);
	storage_button->setChecked(true);
    } else storage_button->setChecked(false);
    conf->setGroup("Network");
    ip_box->setText(conf->readEntry("IP","192.168.129.201"));
    mask_box->setText(conf->readEntry("NETMASK", "255.255.255.0"));
    gw_box->setText(conf->readEntry("GATEWAY"));
    dns_box->setText(conf->readEntry("DNS"));
    conf->setGroup("Storage");
    drive_box->setCurrentItem(conf->readNumEntry("Drive", 0));
    delete conf;
}

Usbd::~Usbd()
{
}

void Usbd::apply()
{
    Config *conf = new Config("Usbd");
    conf->setGroup("Emulation");
    conf->writeEntry("Serial", serial_button->isChecked());
    conf->writeEntry("Network", net_button->isChecked());
    conf->writeEntry("Storage", storage_button->isChecked());
    conf->setGroup("Network");
    conf->writeEntry("IP", ip_box->text());
    conf->writeEntry("NETMASK", mask_box->text());
    conf->writeEntry("GATEWAY", gw_box->text());
    conf->writeEntry("DNS", dns_box->text());
    conf->setGroup("Storage");
    conf->writeEntry("Drive", drive_box->currentItem());
    delete conf;
    QString type="";
    if (serial_button->isChecked()) {
	type = "serial";
    }
    if (net_button->isChecked()) {
	type = "net";
	QFile rc("/etc/hotplug/usbdnet.conf");
	if ( rc.open(IO_WriteOnly) ) {
	    QTextStream stream(&rc);
	    stream << "IP=" << ip_box->text() << "\n";
	    stream << "NETMASK=" << mask_box->text() << "\n";
	    stream << "GATEWAY=" << gw_box->text() << "\n";
	    stream << "DNS=" << dns_box->text() << "\n";
	    stream << "DHCPS=yes\n";
	    stream << "DHCPC=no\n";
	}
    }
    if (storage_button->isChecked()) {
	type = "storage";
	QFile rc("/etc/hotplug/usbdstorage.conf");
	if ( rc.open(IO_WriteOnly) ) {
	    QTextStream stream(&rc);
	    QString device="";
	    switch (drive_box->currentItem()) {
		case 1: 
		    device="/dev/mmcda1"; 
		    break;
		default:
		    device="/dev/hda1"; 
		    break;
	    }
	    stream << device << "\n";
	}
    }
    write_type(type);
    QString cmd = "/etc/usbcontrol " + type;
    system(cmd);
}

void Usbd::write_type(const char *t)
{
    QFile rc("/etc/hotplug/usbd.ftype");
    if ( rc.open(IO_WriteOnly) ) {
	QTextStream stream(&rc);
	stream << t << "\n";
    }
}

void Usbd::net_but(int b)
{
    if (b) {
	ip_box->setEnabled(true);
	mask_box->setEnabled(true);
	gw_box->setEnabled(true);
	dns_box->setEnabled(true);
	TextLabel1->setEnabled(true);
	TextLabel2->setEnabled(true);
	TextLabel3->setEnabled(true);
	TextLabel4->setEnabled(true);
    } else {
	ip_box->setEnabled(false);
	mask_box->setEnabled(false);
	gw_box->setEnabled(false);
	dns_box->setEnabled(false);
	TextLabel1->setEnabled(false);
	TextLabel2->setEnabled(false);
	TextLabel3->setEnabled(false);
	TextLabel4->setEnabled(false);
    }
}

void Usbd::storage_but(int b)
{
    if (b) drive_box->setEnabled(true);
    else drive_box->setEnabled(false);
}
