// -*- compile-command: "g++ -I.. -g -c sheet.cc " -*-
#include "first.h"
/*
 *  Copyright (C) 2002 B. Parisse, Institut Fourier, 38402 St Martin d'Heres
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _GIAC_SHEET_H
#define _GIAC_SHEET_H
#include "gen.h"
#ifdef FL_DEVICE
#include <FL/fl_printer_chooser.H>
#endif // FL_DEVICE
#ifdef HAVE_LIBFLVW
#include <FL/Flv_Table.H>
#include <FL/Flve_Input.H>
#endif // LIBFLVW
#include <FL/Fl_Double_Window.H>
#include <FL/fl_draw.H>
#include <FL/fl_message.H>
#ifndef NO_NAMESPACE_GIAC
namespace giac {
#endif // ndef NO_NAMESPACE_GIAC

  extern int printer_format;
  extern bool printer_landscape;

#ifdef HAVE_LIBFLVW
  class Flv_Table_Gen : public Flv_Table{
  public:
    matrice m;
    matrice lc; // elements are lcell(m[i][j])
    matrice selected;
    bool is_spreadsheet;
    bool move_right;
    bool changed;
    int sort_col;
    int push_row,push_col;
    context * contextptr;
    bool editing;
    int edit_row,edit_col;
    Flv_Table_Gen(int X,int Y,int W,int H,const char *l=0):Flv_Table(X,Y,W,H,l){ contextptr=0; editing=false;};
    Flv_Table_Gen( int X, int Y, int W, int H,const gen & g,const char *l=0 );
    Flv_Table_Gen( int X, int Y, int W, int H,const matrice & mym,const char *l=0);
    virtual void draw_cell(int Offset,int &X,int &Y,int &W,int &H,int R,int C );
    void enter_move();
    //	Required for editing
    //virtual void save_editor( Fl_Widget *e, int R, int C );
    //virtual void load_editor( Fl_Widget *e, int R, int C );
    //virtual void position_editor( Fl_Widget *e, int x, int y, int w, int h, Flv_Style &s );
    int handle(int event);
    void spread_erase(int nrows,int ncols);
    void spread_insert(int nrows,int ncols);
    void copy();
    void blank();
    void blank(int row_min,int r,int col_min,int c);
    void erase_row_col(int i); // 2 ask, 1 col, 0 row
    void copy_right();
    void copy_down();
    void copy_first_in_selection();
    void paste(const matrice & m);
    void addrowatend();
    void addcolatend();
    void set_matrix(const matrice & m,bool interruptible=false);
    void set_matrix(const gen & g,bool interruptible=false);
    void resizesheet(int nr,int nc);
  };

  void spread_eval_interrupt(matrice & m,matrice & lc,GIAC_CONTEXT0);
  void spread_eval_interrupt(matrice & m,GIAC_CONTEXT0);  
  struct xcas_matrix {
    matrice m;
    bool changed,is_spreadsheet;
    int rows,cols,row,row_end,col,col_end;
    xcas_matrix(const matrice & mym,bool b,bool is_sp,int nr,int nc,int rs,int re,int cs,int ce): m(makefreematrice(mym)),changed(b),is_spreadsheet(is_sp),rows(nr),cols(nc),row(rs),row_end(re),col(cs),col_end(ce) {}
    xcas_matrix(): changed(false),is_spreadsheet(true),rows(50),cols(10),row(0),row_end(0),col(0),col_end(0) { m=makefreematrice(vecteur(50,vecteur(10,zero))); makespreadsheetmatrice(m); }
  };
#else // HAVE_LIBFLVW
typedef int Flv_Table_Gen;
typedef int Flve_Input;
#endif // LIBFLVW


  void widget_ps_print(Fl_Widget * widget);
  void widget_print(Fl_Widget * widget);

  struct editor_string {
    std::string s; 
    bool changed; 
    int pos1,pos2; 
    editor_string(const std::string & mys,bool b,int i,int j):s(mys),changed(b),pos1(i),pos2(j) {}
    editor_string():s(""),changed(false),pos1(0),pos2(0) {}
  };

#ifndef NO_NAMESPACE_GIAC
} // namespace giac
#endif // ndef NO_NAMESPACE_GIAC
#endif // _GIAC_SHEET_H
