/*
 *	error.c - error handling
 *	Copyright (C) 2000 Fred Barnes <frmb2@ukc.ac.uk>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <X11/Xlib.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>

#include "cfg.h"
#include "interface.h"



/*
 *	void show_error (char *filename, int linenum, char *fmt, ...)
 *	Does the error printing
 */
void show_error (char *filename, int linenum, char *fmt, ...)
{
	va_list ap;

	va_start (ap, fmt);
	if (linenum > -1) {
		fprintf (stderr, "%s: %s(%d): ", *_xcontext.argv, filename, linenum);
	} else {
		fprintf (stderr, "%s: ", *_xcontext.argv);
	}
	vfprintf (stderr, fmt, ap);
	fprintf (stderr, "\n");
	va_end (ap);
	return;
}


