/*
 *	gadgets.h - interface to all gadgets
 *	Copyright (C) 2000 Fred Barnes <frmb2@ukc.ac.uk>
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __GADGETS_H
#define __GADGETS_H

extern Gadget *create_toplevel (MyXContext *, char *, int, int, int, int);
extern void destroy_toplevel (Gadget *);
extern Gadget *create_panel (MyXContext *, char *, Gadget *, int, int, int, int);
extern void destroy_panel (Gadget *);
extern Gadget *create_label (MyXContext *, char *, Gadget *, int, int, int, int, char *);
extern void destroy_label (Gadget *);
extern Gadget *create_edit (MyXContext *, char *, Gadget *, int, int, int, int, int, int, void (*)(Gadget *, char*), void (*)(Gadget *, char *), void (*)(Gadget *, char *));
extern void destroy_edit (Gadget *);
extern char *text_of_edit (Gadget *);
extern void settext_of_edit (Gadget *, char *);
extern Gadget *create_button (MyXContext *, char *, Gadget *, int, int, int, int, char *, void (*)(Gadget *));
extern void destroy_button (Gadget *);
extern Gadget *create_listbox (MyXContext *, char *, Gadget *, int, int, int, int, int, char**, Gadget *, void (*)(Gadget *, int));
extern void destroy_listbox (Gadget *);
extern void show_listbox (Gadget *);
extern void hide_listbox (Gadget *);

#endif	/* !__GADGETS_H */

