/* simple AOP test operations to test the AOP
   interface */
#include <stdio.h>
#include "config.h"
#include "audio.h"
#include "aop.h"
#include "memcpy.h"
extern int debug;


/********* AOP COPY ***************************************/
static void treat_copy(unsigned char *dest, unsigned char *src, int l) {
  if(debug>1) fprintf(stderr, "audio_treat_copy %p %p\n", dest, src);
  fast_memcpy(dest, src, l);
}

aop aop_copy = {
  "copy",      /* name */
  AUDIO_S16LE,
  1,
  44100,
  treat_copy
};

/********* END AOP COPY **************************************/

/********* AOP DEMO ***************************************/
#define N 200
static void treat_demo(unsigned char *dest, unsigned char *src, int l) {
  unsigned short *d,*s;
  int i,j;
  if(debug>1) fprintf(stderr, "audio_treat_copy %p %p\n", dest, src);
  for(i=0;i+N<=l;i+=N) {
    d=(short*)(dest+i);
    s=(short *) (src+i);
    for(j=0;j<N/4;j++) d[j]=s[2*j];
    for(j=0;j<N/4;j++) d[N/4+j]=s[2*j+1];
  }
  fast_memcpy(dest+i,src+i,l-i);
}

aop aop_demo = {
  "demo",      /* name */
  AUDIO_S16LE,
  1,
  44100,
  treat_demo
};

/********* END AOP DEMO **************************************/
