/*****************************************************************************
 * $Id: audio-oss.c,v 1.6 2004/09/19 15:55:49 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include "config.h"

#ifdef HAVE_OSS
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#if defined(HAVE_LINUX_SOUNDCARD_H)
#include <linux/soundcard.h>
#elif defined(HAVE_SOUNDCARD_H)
#include <soundcard.h>
#elif defined(HAVE_SYS_SOUNDCARD_H)
#include <sys/soundcard.h>
#elif defined(HAVE_MACHINE_SOUNDCARD_H)
#include <machine/soundcard.h>
#endif

#include "audio.h"
static char *device = "/dev/dsp";
static int fd = -1;

static int oss_check(void) { 
  if(audio_dev) device=audio_dev;
  fd=open (device, O_WRONLY|O_NONBLOCK);
  if(fd<0) fd=open (device, O_RDONLY|O_NONBLOCK);
  if(fd<0) return 0;
  close(fd);
  fd = -1;
  return 1;
}

static int oss_open(int mode, int fmtsample, int nchannels, int freq,
		    int nfrags, int fragsize) {
  int mode_to_flag[]= {
    [AUDIO_RO] = O_RDONLY,
    [AUDIO_WO] = O_WRONLY,
    [AUDIO_RW] = O_RDWR};
  int fmtsample_to_oss[] = {
    [AUDIO_U8] = AFMT_U8,
    [AUDIO_S16LE] = AFMT_S16_LE,
  };
  int aux;
  if(audio_dev) device=audio_dev;
  fd=open (device, mode_to_flag[mode]);
  if(fd<0) {
    fprintf(stderr, "failed to open audio device %s:\n", device);
    perror("open");
    return -1;
  }
#ifndef __FreeBSD__
  if(mode==AUDIO_RW)
    if (ioctl (fd, SNDCTL_DSP_SETDUPLEX, 0)<0)
      perror("DSP_SETDUPLEX");
#endif
  aux = ((int)(log(fragsize)/log(2)+0.5)) | (nfrags<<16);
  if (!ioctl (fd, SNDCTL_DSP_SETFRAGMENT, &aux)<0) {
    perror("DSP_SETFRAGMENT");
    return -1;
  }
  aux=fmtsample_to_oss[fmtsample];
  if (ioctl (fd, SNDCTL_DSP_SETFMT, &aux)<0) {
    perror("DSP_SETFMT");
    return -1;
  }
  if(nchannels==1) aux = 0; else aux=1;
  if (ioctl (fd, SNDCTL_DSP_STEREO, &aux)<0) {
    perror("DSP_STEREO");
    return -1;
  }
  aux=freq;
  if (ioctl (fd, SNDCTL_DSP_SPEED, &aux)<0) {
    perror("DSP_SPEED");
    return -1;
  }
  return 0;
}

static int oss_close(void) {
  if(fd!=-1) close(fd);
  fd=-1;
  return 0;
}

static int oss_read(void *r, int n) {
  n=read(fd,r,n);
  if(n<0) perror("oss_read");
  return n;
}

static int oss_write(void *w, int n) {
  n=write(fd,w,n);
  if(n<0) perror("oss_read");
  return n;
}


struct AUDRIVER audio_oss = {
  "oss",
  oss_check,
  oss_open,
  oss_close,
  oss_read,
  oss_write,
};

#endif
