/*****************************************************************************
 * file_sel.h: a file selector in xaw
 *****************************************************************************
 * $Id: file_sel.h,v 1.1 2004/08/07 23:00:10 pingus77 Exp $
 *****************************************************************************
 *
 * Adapted by Pingus 2004
 *
 *****************************************************************************
 *
 * Copyright (C) 1994/08/13 by Nobuyuki Maruichi
 * From mwxcd 1.32
 *
 * Adviced by S.Kouno(ggxsnd)
 * from ggxsnd.h 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
 *
 ***************************************************************************/

#ifndef _FILE_SELECTOR_H
#define _FILE_SELECTOR_H

#include "xfile.h"

typedef struct _popdownInfo {
	Widget popupWidget;
	Widget popdownShell;
	XtPointer *client_data;
} PopdownInfo;

enum _MenuType {TypeSme, TypeSmeBSB, TypeSmeLine};

struct menu_data {
	int type;
	String widgetName;
	Widget myWidget;
	void (*function)(Widget w, XtPointer client_data, XtPointer call_data);
	XtPointer client_data;
};

struct menuData {
	Widget menuButton;
	Widget menu;
	const char *menuName;
	int num;
	void (*popup)(Widget w, XtPointer client_data, XtPointer call_data);
	void (*popdown)(Widget w, XtPointer client_data, XtPointer call_data);
	struct menu_data *info;
};

typedef struct _modeSelector {
	int paneNo;
	struct menuData *menuInfo;
	int blockNo;
	int partNo;
	struct menu_data *currentPane;
	struct _modeSelector *blockTop;
	XtPointer client_data;
} modeSelector;

typedef struct _selectorPanes {
	int paneNo;
	struct menu_data **panesInfo;
	FileSelctorInfo *fileSelecterInfo;
	void (*option)(Widget w, XtPointer client_data, XtPointer call_data);
	XtPointer client_data;
} selectorPanes;

typedef struct _fsMenuInfo {
	selectorPanes *filesPickupPane;
	selectorPanes *filesSortPane;
	void (*selectFinish)(const char *dirName, const char *fileName);
} fSelectorMenuInfo;

extern selectorPanes filePickupPaneInfo[];
extern selectorPanes fileSortPaneInfo[];

Widget fileDialogInit(Widget parent);
void fileSelectorCall(Widget popupButton, const char *dirName, 
			selectorPanes *selectorPane, selectorPanes *sortPane,
 			void selectFinish(const char *dirName, const char *fileName));
int isDirectory(const char *filename);
int fileCheck(const char *filepath, int dirLength, char *dirName, 
									int fileLength, char *fileName);

void selectFinish(const char *dirName, const char *fileName);
void fileSelector(Widget w, XtPointer client_data, XtPointer call_data);
void Hidefilesel (Widget widget, XEvent * event, String * params, Cardinal * num_params);

#endif /*_FILE_SELECTOR_H*/

