/*****************************************************************************
 * $Id: vop-common.c,v 1.20 2004/10/24 20:58:51 alainjj Exp $
 * Program under GNU General Public License (see ../COPYING)
 *****************************************************************************/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "config.h"
#include "grab.h"
#include "colorspace.h"
#include "vop.h"
#include "strtab.h"
#include "memcpy.h"

extern int have_xv, height_capture, xvtv;
extern void force_capt_height_unless_divx(int height);
extern void set_capture_temp_grab(int grab, int mask);

vop2 *last_vop=NULL;

int vop_autograb=1;
static void vop_set_capt(void) {
  static int height_when_no_vop=-1;
  vop2 *v;
  if(vop_autograb 
#ifdef HAVE_VIDEO_XV
     & !xvtv
#endif
     )
    set_capture_temp_grab(last_vop!=NULL, 2);
  if(height_when_no_vop==-1)
    height_when_no_vop=height_capture;
  v=last_vop;
  while(v!=NULL && v->v->height_dest==0) v=v->prev;
  if(v==NULL) {
    force_capt_height_unless_divx(height_when_no_vop);
    height_when_no_vop=-1;
    return;
  } else
    if(have_xv)
      force_capt_height_unless_divx(v->v->height_dest);
}

static vop2 *add_vop(vop *v) {
  vop2 *v2=malloc(sizeof(vop2)), *v3;
  v2->v=v;
  v2->prev = last_vop;
  v2->bufs=v2->dest_tmp=v2->dest_tmp2=v2->dest_tmp3=NULL;
  v2->buf_cur=0;
  v2->directgrab1=v2->directgrab2=0;
  v2->nbufs=v->nbufs_needed;
  if((last_vop==NULL || !v->post) && grab_prefered_fmt[v->f_src]==v->f_src) {
    v2->directgrab1=1;
    v2->nbufs_prec=-1;
  }
  if(last_vop==NULL || v->post) {
    v2->prev = last_vop;
    last_vop=v2;
  } else {
    v2->prev = NULL;
    v3=last_vop;
    while(v3->prev!=NULL) v3=v3->prev;
    v3->prev=v2;
    if(v3->directgrab2) {
      free(v3->bufs); v3->bufs=NULL;
    }
    v3->directgrab1=v3->directgrab2=0;
  }
  vop_set_capt();
  return v2;
}

static void sup_vop(vop2 *v) {
  if(v->dest_tmp) free(v->dest_tmp);
  if(v->dest_tmp2) free(v->dest_tmp2);
  if(v->dest_tmp3) free(v->dest_tmp3);
  if(v->bufs) {
    int i;
    if(!v->directgrab2)
      for(i=0;i<v->nbufs;i++)
	if(v->bufs[i]) free(v->bufs[i]);
    free(v->bufs);
  }
  if(v==last_vop) 
    last_vop=v->prev;
  else {
    vop2 *v2=last_vop;
    while(v2!=NULL && v2->prev!=v) v2=v2->prev;
    if(v2!=NULL) {
      v2->prev=v->prev;
      if(v2->prev==NULL) {
	if(grab_prefered_fmt[v2->v->f_src]==v2->v->f_src) {
	  v2->directgrab1=1;
	  v2->nbufs_prec=-1;
	}
      }
    }
  }
  vop_set_capt();
  free(v);
}

static inline int div_round (int dividend, int divisor)  {
  return (dividend + (divisor>>1)) / divisor;
}
static inline int rescale (int x, int lold, int lnew) {
    return div_round(x * (lnew - 1), lold - 1);
}
static void changeh(video_fmt f, void *dest, int h2, 
		    void*src, int w, int h) {
  int t=size_img(f,w,1),i;
  if(debug>1) fprintf(stderr, "changeh h=%d h2=%d w=%d\n",h,h2,w);
  for(i=0;i<h2;i++,dest+=t)
    fast_memcpy(dest,src+rescale(i,h2,h)*t,t);
}

/* The code of this function is long because 
   I wanted NO unnecessary copy memory to be done */
int get_image2_vop_onetry(vop2 *v, void *dest,video_fmt f, int width, int height) {
  int hdst,wsrc,hsrc,i;
  void *src;
  if(v==NULL) return get_image2_before_vop(dest,f,width,height);
  if(debug>=2)
    fprintf(stderr,"VOP2 %s f=%s %dx%d\n", v->v->name, 
	    int_to_str (f,video_fmt_names),width,height);
  if(v->v->height_dest==-1)
    hdst=cur_maxheight;
  else if(v->v->height_dest>0)
    hdst=v->v->height_dest;
  else 
    hdst=height;
  if(v->v->width_src==-1)
    wsrc=cur_maxwidth;
  else if(v->v->width_src)
    wsrc=v->v->width_src;
  else
    wsrc=width;
  if(v->v->height_src==-1)
    hsrc=cur_maxheight;
  else if(v->v->height_src)
    hsrc=v->v->height_src;
  else
    hsrc=hdst;

  if(v->v->nbufs_needed<=1) {
    src=get_image_vop(v->prev,v->v->f_src,wsrc,hsrc);
    if(src==NULL) return 0;
  }
  else {
    int mustreinit=0;
    if(wsrc!=v->width_cur || hsrc!=v->height_cur) {
      v->width_cur=wsrc;
      v->height_cur=hsrc;
      mustreinit=1;
    }
    if(v->directgrab1 && nbufs!=v->nbufs_prec) {
      mustreinit=1;
      if(v->bufs!=NULL) {
	for(i=0;i<v->nbufs;i++) 
	  if(v->bufs[i] && !v->directgrab2) free(v->bufs[i]);
	free(v->bufs);
	v->bufs=NULL;
      }
      v->nbufs_prec=nbufs;
      v->directgrab2=0;
      v->nbufs=v->v->nbufs_needed;
      /* put #if 0 if you have some problems
	 because it is possible that the TV-card modifies the other buffers...*/
#if 1
      if(nbufs>=v->v->nbufs_needed+1) {
	v->directgrab2=1;
	v->nbufs=nbufs;
      }
#endif
    }
    if(v->bufs==NULL) {
      v->bufs=malloc(v->nbufs*sizeof(void*));
      for(i=0;i<v->nbufs;i++) v->bufs[i]=NULL;
      mustreinit=1;
    }
    if(v->directgrab2) {
      for(i=0;i<v->nbufs;i++)
	if(v->bufs[i]!=grabbers[grabber]->get_buf(i)) {
	  mustreinit=1;
	  break;
	}
    } else if(mustreinit) {
      int t=size_img(v->v->f_src,wsrc,hsrc);
      for(i=0;i<v->nbufs;i++){
	v->bufs[i]=realloc(v->bufs[i],t);
      }
    }
    if(mustreinit) {
      if(debug>=2) fprintf(stderr, "vop: REINITIALIZATION %s\n", v->v->name);
      for(i=0;i<v->v->nbufs_needed-1;i++) {
	if(v->directgrab2) {
	  if(!grabbers[grabber]->get_img(v->v->f_src,wsrc,hsrc))
	    return 0;
	} else {
	  v->buf_cur++;if(v->buf_cur>=v->nbufs) v->buf_cur=0;
	  if(!get_image2_vop(v->prev,v->bufs[v->buf_cur],v->v->f_src,wsrc,hsrc))
	    return 0;
	}
      }
      if(v->directgrab2) 
	/* must be done after since the first get_img  has probably modified
	   the buffers */
	for(i=0;i<v->nbufs;i++) {
	  v->bufs[i]=grabbers[grabber]->get_buf(i);
	}
      v->buf_cur=img;
      if(v->v->reinit) v->v->reinit();
    }
    v->buf_cur++; if(v->buf_cur>=v->nbufs) v->buf_cur=0;
    if(v->directgrab2) {
      if(!grabbers[grabber]->get_img(v->v->f_src,wsrc,hsrc))
	return 0;
    } else {
      if(!get_image2_vop(v->prev,v->bufs[v->buf_cur],v->v->f_src,wsrc,hsrc))
	return 0;
    }
    src=v->bufs[v->buf_cur];
  }
  if(f==v->v->f_dest && hdst==height) {
    if(!v->v->treat_image(v,dest,src,width,height))
      return -1;
  } else if(hdst==height) {
    v->dest_tmp=realloc(v->dest_tmp,
			size_img(v->v->f_dest, width,height));
    if(!v->v->treat_image(v,v->dest_tmp, src, width, height))
      return -1;
    convert2(v->dest_tmp, v->v->f_dest, dest, f,width,height);
  } else if(f==v->v->f_dest) {
    v->dest_tmp=realloc(v->dest_tmp,
			size_img(v->v->f_dest, width,hdst));
    if(!v->v->treat_image(v,v->dest_tmp, src, width, hdst))
      return -1;
    changeh(f,dest,height,v->dest_tmp,width,hdst);
  } else {
    v->dest_tmp=realloc(v->dest_tmp,
			size_img(v->v->f_dest, width,hdst));
    if(!v->v->treat_image(v,v->dest_tmp, src, width, hdst))
      return -1;
    v->dest_tmp2=realloc(v->dest_tmp2,
			 size_img(v->v->f_dest, width,height));
    changeh(v->v->f_dest, v->dest_tmp2,height,v->dest_tmp,width,hdst);
    convert2(v->dest_tmp2, v->v->f_dest, dest, f,width,height);
  }
  return 1;
}

int get_image2_vop(vop2 *v, void *dest,video_fmt f, int width, int height) {
  int i=0,r;
  do {
    r=get_image2_vop_onetry(v,dest,f,width,height);
    i++;
  } while(r==-1 && i<4);
  return r>0;
}


void *get_image_vop(vop2 *v,video_fmt f, int width, int height) {
  if(v==NULL) return get_image_before_vop(f,width,height);
  if(debug>=2)
    fprintf(stderr,"VOP %s f=%s %dx%d\n", v->v->name, 
	    int_to_str (f,video_fmt_names),width,height);
  v->dest_tmp3=realloc(v->dest_tmp3,size_img(f,width,height));
  if(!get_image2_vop(v, v->dest_tmp3,f,width,height)) return NULL;
  return v->dest_tmp3;
}

static struct _vopregistered {
  vop *v;
  struct _vopregistered *prev;
} *vops = NULL;

void vop_register(vop *v) {
  struct _vopregistered *v2=malloc(sizeof(struct _vopregistered));
  v2->prev=vops;
  v2->v=v;
  vops=v2;
}

extern vop vop_copy;
extern vop vop_halflate;
extern vop vop_monoc;
extern vop vop_copy_b;
extern vop vop_deint_lb;
#ifdef ARCH_X86
extern vop vop_deint_bob, vop_deint_greedy, vop_deint_onefield,vop_deint_weave;
#endif

void vop_init(char *cmdline) {
  char *tok,*ctok;
  vop_register(&vop_copy);
  vop_register(&vop_halflate);
  vop_register(&vop_monoc);
  vop_register(&vop_copy_b);
  vop_register(&vop_deint_lb);
#ifdef ARCH_X86
  vop_register(&vop_deint_bob);
  vop_register(&vop_deint_greedy);
  vop_register(&vop_deint_onefield);
  vop_register(&vop_deint_weave);
#endif
  if(!cmdline) return;
  cmdline=strdup(cmdline);
  if(cmdline==NULL) return;
  tok= strtok_r(cmdline, ":",&ctok);
  while(tok!=NULL) {
    activate_vop(tok);
    tok=strtok_r(NULL,":",&ctok);
  }
  free(cmdline);
  if(debug) {
    vop2 *v=last_vop;
    fprintf(stderr, "VIDEO_OPERATIONS : ");
    while(v!=NULL) {
      fprintf(stderr, "%s ",v->v->name);
      v=v->prev;
    }
    fprintf(stderr,"\n");
  }
}

static vop2 *vop_running_byname(char *name) {
  vop2 *v=last_vop;
  while(v!=NULL && strcmp(v->v->name,name)) v=v->prev;
  return v;
}

static vop *vop_registered_byname(char *name) {
  struct _vopregistered *v=vops;
  while(v!=NULL && strcmp(v->v->name,name)) v=v->prev;
  if(v==NULL) return NULL; else return v->v;
}

int toggle_vop(char *name) {
  vop *v0;
  vop2 *v=vop_running_byname(name);
  if(v!=NULL) {sup_vop(v); return 1;}
  v0=vop_registered_byname(name);
  if(v0!=NULL) {add_vop(v0); return 2;}
  fprintf(stderr, "*** WARNING no vop %s registered\n", name);
  return 0;
}

void activate_vop(char *name) {
  vop *v0;
  vop2 *v=vop_running_byname(name);
  if(v!=NULL) return;
  v0=vop_registered_byname(name);
  if(v0!=NULL) {add_vop(v0); return;}
  fprintf(stderr, "*** WARNING no vop %s registered\n", name);
}

void deactivate_vop(char *name) {
  vop2 *v=vop_running_byname(name);
  if(v!=NULL) sup_vop(v);
}
