/*
   SHARP CE-AG06 console frontend
   Copyright 2005 Alexander Chukov <sash@pdaXrom.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <dirent.h>
#include <zlib.h>
#include <jpeglib.h>
#include <errno.h>
#include <time.h>

#include "zcamera.h"

#define WIDTH	640
#define HEIGHT	480

char *buf;


void write_ppm(char *name, int w, int h, unsigned short *data)
{
    int x, y;
    FILE *f = fopen(name, "wb");
    if (f) {
	fprintf(f, "P6\n");
	fprintf(f, "%d %d\n", w, h);
	fprintf(f, "255\n");
	
	for (y = 0; y < h; y++) {
	    for (x = 0; x < w; x++) {
		unsigned int r, g, b;
		r = ((data[y * w + x] >> 11) << 3) & 0xff;
		g = ((data[y * w + x] >> 5 ) << 2) & 0xff;
		b = ((data[y * w + x]      ) << 3) & 0xff;
		fputc(r, f);
		fputc(g, f);
		fputc(b, f);
	    }
	}
	
	fclose(f);
    }
}

int main(int argc, char *argv[])
{
    int w, h;
    
    cam_open();
    
    w = WIDTH;
    h = HEIGHT;
    
    buf = (char *) malloc(w * h * 2);
    
    cam_setCaptureFrame(w, h, 256, 0);
    
    sleep(1);
    
    cam_captureFrame(w, h, 256, buf);

    write_ppm("test.ppm", w, h, (unsigned short *) buf);
    
    free(buf);
    
    cam_close();
    return 0;
}
