#!/usr/bin/perl -w

# This is the server accepting administration requests from the user (cms.sh).
# It does not handle the requests and just passes them to corresponding
# publication managers.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

use 5.8.8;
use strict;
use FindBin;
BEGIN {
    push (@INC, "$FindBin::Bin/../lib");
}

use CMSsh::Messages;
use CMSsh::Config;
use CMSsh::Utils qw(collect_modes_data);

my $msg = CMSsh::Messages->new;
my $cfg = CMSsh::Config->new;

my @handlers = collect_modes_data(
    sub {
        my $mode = shift;
        return @{$mode->get_pub_managers};
    },
    sub {
        my $mode = shift;
        return scalar @{$mode->get_pub_managers};
    }
);

# TBD: test for symbol duplications
my %handlers = map { $_->get_symbol => $_ } @handlers;

my $cmd = shift (@ARGV);

if ($cmd eq 'cfg') {
    my (@cmds_upload, @cmds_nodst);
    foreach my $symbol (keys %handlers) {
        my $syntax = $handlers{$symbol}->get_syntax();
        foreach my $oper (keys %$syntax) {
            if ($syntax->{$oper}->{src}->{is_file_path}) {
                push @cmds_upload, "$oper$symbol";
                push @cmds_nodst, "$oper$symbol"
                    unless defined $syntax->{$oper}->{dst};
            }
        }
    }
    print 
# The list of commands which require uploading to the server
          "CMDS_UPLOAD=(" . join(" ", @cmds_upload) . ");" .
# The list of commands which require uploading,
# but have no destination parameter"
          "CMDS_NODST=(" . join(" ", @cmds_nodst) . ");" .
          "SERVER_TMP_DIR=" . $cfg->get('ROOT_TMP');
    exit;
}

$cmd =~ /^(\w{2})(\w)$/;
my ($oper, $type) = ($1, $2);

# Check whether the corresponding handler exists
die $msg->get('UNKNOWN_CMD', $cmd)
    unless ($oper && $type && $handlers{$type} &&
            defined $handlers{$type}->get_syntax()->{$oper});

# Handle the request
$handlers{$type}->process($oper, \@ARGV);

