#!/bin/sh

# This is an administration script of cms.sh. It's used for managing a site
# content from the user's side.
#
# Accepts the following parameters:
#   1 - a command, which determines a type of operation to be performed (mkd,
#     mkc, mva, rmD, etc) (mandatory).
#   2 - a list of URIs of the source publications on which the operation will
#     be performed (mandatory).
#   3 - an URI of the destination publication collection in which the sources
#     will be stored/moved or a new name for the source (mandatory).
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

SCP='/usr/bin/scp'
SSH='/usr/bin/ssh'

if [ $# -lt 2 ] ; then
    echo "Usage: $0 cmd source1 [source2 ...] [destination]"
    exit 1
fi

if [ -f ~/.cmsshrc ]; then
    source ~/.cmsshrc
else
    if [ ! -f /etc/cmssh.conf ] ; then
        echo "Error reading the configuration file!"
        exit 1;
    fi
    source /etc/cmssh.conf
fi

# Checks whether an array contains a particular element
contains() {
    desired=$1
    eval array=(\${$2[*]})
    for i in ${array[@]}; do
        if [[ $i == $desired ]] ; then
            return 0
        fi
    done
    return 1
}

echo "Fething the latest configuration from the server..."
CFG=`$SSH -p $PORT $USER@$SERVER $SERVER_ADMIN cfg`
if [ $? -ne 0 ] ; then
    echo "Error fetching the latest configuration!"
    exit 1;
fi
eval $CFG
if [ $? -ne 0 ] ; then
    echo "Error evaluating the configuration!"
    exit 1;
fi

# Upload new content to the temp directory
if contains $1 CMDS_UPLOAD ; then
    I=2
    contains $1 CMDS_NODST
    NODST=$?
    echo "aaa"
    while [[ $NODST -eq 0 && $I -le $# || $I -lt $# ]]; do
        echo "Sending ${!I} to the server..."
# Don't pass bare file names to scp, need to prefix them with './'
        if [ -z `expr match "${!I}" '^\(/\|\./\|\.\./\)'` ]; then
            PREFIX='./'
        else
            PREFIX=''
        fi
        $SCP -B -P $PORT "$PREFIX${!I}" $USER@$SERVER:$SERVER_TMP_DIR
        if [ $? -ne 0 ] ; then
            echo "Error sending ${!I} to the server!"
            exit 1;
        fi
        let I++
    done
fi

# Quote the arguments
I=1
while [ $I -le $# ]; do
    ARGS="$ARGS\"${!I}\" "
    let I++
done

# Execute CMS script on the server
echo "Performing the request..."
$SSH -p $PORT $USER@$SERVER $SERVER_ADMIN $ARGS
if [ $? -ne 0 ] ; then
    echo "Error performing the request!"
    exit 1;
fi

echo "All done."
exit 0
