# The Config class defines common settings used by the
# Presentation/Administration scripts and another classes.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Config;

use strict;
use utf8;
use CMSsh::Dictionary;
use CMSsh::Messages;

my $Msg = CMSsh::Messages->new;

################################################################################
# Configuration parameters

my $Settings = {
# Settings related to file system
    ROOT_WWW =>         '/var/www',
    ROOT_TMP =>         '/tmp',
    DIR_HTDOCS =>       'htdocs',
    DIR_TMPL =>         'tmpl',
    DIR_MEDIA =>        'media',
    DIR_IMG =>          'images',

# Owner info
    OWNER_NAME =>       'Owner Name',
    OWNER_EMAIL =>      'user.name@email.domain',

# Copyright info
    COPYRIGHT_YEARS =>  '2011',
    LICENSE =>          'GNU Free Documentation License 1.3',

# Various parameters
    URLKEY_DOWNLOAD =>  'download',
    EXT_IMG =>          'jpg',
    IMG_QUALITY =>      100,
    ENABLED_MODES =>    ['Document', 'Gallery', 'Video', 'Storage'],
};

################################################################################
# Do not edit below this line

$_ = $Settings;
$_->{USE_HTML5} =       0;
$_->{HTDOCS_MEDIA} =    '/' . $_->{DIR_MEDIA};
$_->{HTDOCS_IMG} =      $_->{HTDOCS_MEDIA}. '/' . $_->{DIR_IMG};
$_->{ROOT_HTDOCS} =     $_->{ROOT_WWW} . '/' . $_->{DIR_HTDOCS};
$_->{ROOT_TMPL} =       $_->{ROOT_WWW} . '/' . $_->{DIR_TMPL};

sub new ($) {
    my $class_name = shift;

    my $self = {
        _dict => CMSsh::Dictionary->new($Settings),
    };
    die $Msg->get('CANT_INST_DICT') unless ($self->{_dict});

    bless $self, $class_name;
    return $self;
}

sub _install_param ($$$) {
    my ($self, $key, $value) = @_;
    $self->{_dict}->add_pair($key, $value)
        or die $Msg->get('CANT_ADD_PAIR');
}

sub _change_param ($$) {
    my ($self, $key, $value) = @_;
    $self->{_dict}->change_value($key, $value)
        or die $Msg->get('CANT_CHANGE_VAL');
}

sub _install_gloss ($$) {
    my ($self, $gloss) = @_;
    $self->{_dict}->add_gloss($gloss)
        or die $Msg->get('CANT_ADD_GLOSS');
}

sub get ($$) {
    my ($self, $key) = @_;
    return $self->{_dict}->get_value($key);
}

1
