# The Config class defines settings specific to the the GalleryMode.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::GalleryMode::Config;

our @ISA = qw(CMSsh::Config);

use strict;
use utf8;

################################################################################
# Configuration parameters

my $Settings = {
    DIR_THUMB =>         '.thumbnails',
    DIR_PREVIEW =>       '.preview',
    URLKEY_GALLERY =>    'gallery',
    TITLE_GALLERY =>     'Gallery',
    PREVIEW_WIDTH =>     1024,
    PREVIEW_HEIGHT =>    768,
    THUMB_SIZE =>        240,
    INMENU_PRIORITY =>   0,
};

################################################################################
# Do not edit below this line

sub new ($) {
    my ($class_name) = @_;

    my $self = CMSsh::Config->new;
    $self->_install_gloss($Settings);

    $self->_install_param('HTDOCS_THUMB', $self->get('HTDOCS_IMG') . '/' .
                                          $self->get('DIR_THUMB'));
    $self->_install_param('HTDOCS_PREVIEW', $self->get('HTDOCS_IMG') . '/' .
                                            $self->get('DIR_PREVIEW'));
    $self->_install_param('ROOT_IMG', $self->get('ROOT_HTDOCS') .
                                      $self->get('HTDOCS_IMG'));
    $self->_install_param('ROOT_PREVIEW', $self->get('ROOT_HTDOCS') .
                                          $self->get('HTDOCS_PREVIEW'));
    $self->_install_param('ROOT_THUMB', $self->get('ROOT_HTDOCS') .
                                        $self->get('HTDOCS_THUMB'));

    bless $self, $class_name;
    return $self;
}

1
