# The View class represents the GalleryMode to the presentation layer.
# Basically it provides one link to the root album (for the menu) and links to
# all publications in the hierarchy from the current publication up to the root
# album (for the path).
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::GalleryMode::View;

our @ISA = qw(CMSsh::Mode::View);

use strict;
use CMSsh::Mode::View;
use CMSsh::GalleryMode::Config;

my $Cfg = CMSsh::GalleryMode::Config->new;

sub get_tmpl_params (;$) {
    return [qw(HTDOCS_IMG HTDOCS_PREVIEW HTDOCS_THUMB URLKEY_GALLERY)];
}

sub get_menu_items ($$) {
    my ($self, $publication) = @_;

    return [{ href => '/' . $Cfg->get('URLKEY_GALLERY'),
              title => $Cfg->get('TITLE_GALLERY'),
              is_active => defined $publication,
              priority => $Cfg->get('INMENU_PRIORITY') }];
}

sub get_path ($$) {
    my ($self, $publication) = @_;

    my @result;
    my $curr_path = '/' . $Cfg->get('URLKEY_GALLERY') . '/';
    my @items = split('/', $publication->get_uri);
    foreach my $i (1..$#items) {
        push (@result, { href => $curr_path . $items[$i],
                         title => $items[$i] });
        $curr_path .= "$items[$i]/";
    }

    return \@result;
}

1
