# Mode is the interface of a mode to the core. It provides publication managers
# to the administration server, a view to the TemplateHandler and so on.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Mode;

use strict;
use CMSsh::Messages;

my $Msg = CMSsh::Messages->new;

sub new ($) {
    my $class_name = shift;

    my $self = {};
    bless $self, $class_name;

    return $self;
}

sub _extract_name ($$) {
    my ($self, $package_name) = @_;
    return ($package_name =~ /^\w+::(\w+)/) ? $1 : undef;
}

sub get_name () {
    die $Msg->get('ABSTRACT_CLASS');
}

# The View class constructor accepts $self
sub get_view ($) {
    return undef;
}

# The PublicationManager class constructor accepts $self
sub get_pub_managers ($) {
    return [];
}

sub get_config (;$) {
    return CMSsh::Config->new;
}

sub get_messages (;$) {
    return CMSsh::Messages->new;
}

sub find_publication () {
    die $Msg->get('ABSTRACT_CLASS');
}

1
