# PublicationCollection is a type of publication, which may contain another
# publications. Listing is a mandatory operation.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Mode::PublicationCollection;

our @ISA = qw(CMSsh::Mode::Publication);

use strict;
use CMSsh::Messages;
use CMSsh::Mode::Publication;

my $Msg = CMSsh::Messages->new;

sub is_root ($) {
    my $self = shift;
    return $self->{_uri} eq '/';
}

sub get_listing () {
    die $Msg->get('ABSTRACT_CLASS');
}

1
