# SinglePublication is a type of publication, which can not contain another
# publications. 
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::Mode::SinglePublication;

our @ISA = qw(CMSsh::Mode::Publication);

use strict;
use CMSsh::Mode::Publication;
use CMSsh::Messages;

my $Msg = CMSsh::Messages->new;

sub new ($$) {
    my ($class_name, $uri) = @_;

    my $self = CMSsh::Mode::Publication->new($uri);
    unless ($self) {
        warn $Msg->get('CANT_INST_PUB', $uri);
        return undef;
    }

# Single publication must be located in a publication collection.
    my $parent_uri = $self->get_parent_uri;
    unless ($parent_uri) {
        warn $Msg->get('ORPHANED_PUB', $uri);
        return undef;
    }

    bless $self, $class_name;
    return $self;
}


1
