# The Mode class represents the storage module to the core.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::StorageMode;

our @ISA = qw(CMSsh::Mode);

use strict;
use CMSsh::Mode;
use CMSsh::StorageMode::File;
use CMSsh::StorageMode::Directory;
use CMSsh::StorageMode::FileManager;
use CMSsh::StorageMode::DirManager;

sub get_name ($) {
    my $self = shift;
    return $self->_extract_name(__PACKAGE__);
}

sub get_pub_managers ($) {
    my $self = shift;
    return [
        CMSsh::StorageMode::FileManager->new($self),
        CMSsh::StorageMode::DirManager->new($self),
    ];
}

sub get_config (;$) {
    return CMSsh::StorageMode::Config->new;
}

sub get_collection ($;$) {
    my ($self, $uri) = @_;
    return CMSsh::StorageMode::Directory->new($uri);
}

sub find_publication ($$) {
    my ($self, $uri) = @_;

    local $SIG{__WARN__} = sub {};
    if (my $img = CMSsh::StorageMode::File->new($uri)) {
        return $img;
    } elsif (my $alb = CMSsh::StorageMode::Directory->new($uri)) {
        return $alb;
    } else {
        return undef;
    }
}

1
