# FileManager handles administration requests related to file publications.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::StorageMode::FileManager;

our @ISA = qw(CMSsh::Administration::PublicationManager);

use strict;
use CMSsh::Administration::PublicationManager;
use CMSsh::StorageMode::Messages;
use CMSsh::StorageMode::Config;
use CMSsh::StorageMode::File;
use CMSsh::StorageMode::Directory;

my $Msg = CMSsh::StorageMode::Messages->new;

sub new ($) {
    my ($class_name, $mode) = @_;

    my $self = CMSsh::Administration::PublicationManager->new($mode);
    $self->{_syntax}->{mk} = { handler => sub { $self->_mk(@_) },
                               src => { is_file_path => 1, max_number => 1 },
                               dst => 1 };

    bless $self, $class_name;
    return $self;
}

sub get_symbol (;$) {
    return 'f';
}

sub get_pub_type (;$) {
    return CMSsh::StorageMode::File->get_type;
}

sub _mk ($$) {
    my ($self, $params) = @_;

    my $dest_dir = CMSsh::StorageMode::Directory->new($params->{dst})
        or die $Msg->get('WRONG_DST');

    foreach (@{$params->{src}}) {
        my $file = $self->_get_input_file($_);
        $dest_dir->create_subfile($file) or die $Msg->get('CANT_MAKE_PUB');
    }
}

1
