# VidManager handles administration requests related to video publications.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com>

package CMSsh::VideoMode::VidManager;

our @ISA = qw(CMSsh::Administration::PublicationManager);

use strict;
use CMSsh::Administration::PublicationManager;
use CMSsh::VideoMode::Messages;
use CMSsh::VideoMode::Config;
use CMSsh::VideoMode::Video;
use CMSsh::VideoMode::Videoteque;

my $Msg = CMSsh::VideoMode::Messages->new;
my $Cfg = CMSsh::VideoMode::Config->new;

sub new ($) {
    my ($class_name, $mode) = @_;

    my $self = CMSsh::Administration::PublicationManager->new($mode);
    $self->{_syntax}->{mk} = { handler => sub { $self->_mk(@_) },
                               src => { is_file_path => 1 } };
    $self->{_syntax}->{mv} = undef;

    bless $self, $class_name;
    return $self;
}

sub get_symbol (;$) {
    return 'v';
}

sub get_pub_type (;$) {
    return CMSsh::VideoMode::Video->get_type;
}

sub _mv ($$) {
    die $Msg->get('FORBIDDEN_OPER');
}

sub _mk ($$) {
    my ($self, $params) = @_;

    my $videoteque = CMSsh::VideoMode::Videoteque->new
        or die $Msg->get('CANT_INST_VT');

    foreach (@{$params->{src}}) {
        my $file = $self->_get_input_file($_);
        my $vid_file = CMSsh::VideoMode::VidFile->new($file->get_path)
            or die $Msg->get('CANT_INST_FSO', $file->get_path);
        $videoteque->create_subvid($vid_file) or die $Msg->get('CANT_MAKE_PUB');
    }
}

1
