# Video is a single publication of this mode. On the file system layer it is
# represented by a video file.
#
# This file is part of cms.sh.
#
# cms.sh is free software: you can redistribute it and/or modify it under the
# terms of the GNU General Public License as published by the Free Software
# Foundation, either version 3 of the License, or (at your option) any later
# version.
#
# cms.sh is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
# A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# cms.sh. If not, see <http://www.gnu.org/licenses/>.
#
# (c) 2010-2011 Vitaly Minko <vitaly.minko@gmail.com> 

package CMSsh::VideoMode::Video;

our @ISA = qw(CMSsh::Mode::SinglePublication);

use strict;
use CMSsh::Mode::SinglePublication;
use CMSsh::VideoMode::VidFile;
use CMSsh::VideoMode::Messages;
use CMSsh::VideoMode::Config;
use URI::Escape;

my $Msg = CMSsh::VideoMode::Messages->new;
my $Cfg = CMSsh::VideoMode::Config->new;

################################################################################
# Common methods

sub new ($$) {
    my ($class_name, $uri) = @_;

    my $self = CMSsh::Mode::SinglePublication->new($uri);
    unless ($self) {
        warn $Msg->get('CANT_INST_PUB', $uri);
        return undef;
    }

     my $vid_path =  CMSsh::VideoMode::Videoteque->new->get_dir->get_path .
                         '/' . $self->{_name} . '.' .
                         CMSsh::VideoMode::VidFile->get_ext;
    $self->{_video} = CMSsh::VideoMode::VidFile->new($vid_path);
    unless ($self->{_video}) {
        warn $Msg->get('CANT_INST_FSO', $vid_path);
        return undef;
    }

    bless $self, $class_name;
    return $self;
}

sub get_type ($) {
    my $self = shift;
    return $self->_extract_type(__PACKAGE__);
}

################################################################################
# Presentation methods

sub get_view ($) {
    my $self = shift;
    return { href => uri_escape_utf8($self->{_video}->get_htdocs_path,
                                     "^A-Za-z0-9\-_.!~*'()/"),
             caption => $self->{_name}, };
}

################################################################################
# Administration methods

sub rename ($$) {
    my ($self, $new_name) = @_;

    my $new_uri = "/$new_name";
    if (CMSsh::VideoMode->find_publication($new_uri)) {
        warn $Msg->get('OCCUPIED_URI', $new_uri);
        return 0;
    }

    $self->{_video}->rename($new_name)
    or do {
        warn $Msg->get('CANT_RENAME_FSO', $self->{_video}->get_path, $new_name);
        return 0;
    };

    $self->_set_uri("/$new_name");
    $self->_update_name;

    return 1;
}

sub remove ($) {
    my $self = shift;

    $self->{_video}->remove
    or do {
        warn $Msg->get('CANT_REMOVE_FSO', $self->{_video}->get_path);
        return 0;
    };

    return 1;
}

1
