Title:      F5er user's manual
Summary:    F5er is a daemon, which allows user to receive notifications about
            changes in web pages, which do not offer a built-in RSS support.
            On a user's request, it downloads a predefined web page, extracts
            target information from the web page content and generates an RSS   
            feed on the basis of the content.
Copyright:  (c) 2011-2017 Vitaly Minko
            Content is available under GNU Free Documentation License 1.3 and
            Creative Commons Attribution-Share Alike 3.0 Unported License
Date:       2 Sep 2017
Web:        http://vminko.org/f5er


NAME
----

F5er - RSS feed maker for arbitrary web pages

SYNOPSIS
--------

    f5er [--address=hostname] [--port=number] [--config=file]

    f5er --help

DESCRIPTION
-----------

__F5er__ is a daemon, which allows user to receive notifications about changes
in web pages, which do not offer a built-in RSS support.  On a user's request,
it downloads a predefined web page, extracts target information from the web
page content and generates an RSS feed on the basis of the content.  The actual
determination whether the web page was changed or not is performed by the
user's RSS aggregator.  So F5er is a universal intermediary between any web
site and any RSS aggregator.

In order to receive notifications, user needs to add a new feed to his RSS
aggregator for each F5er channel defined in the configuration file.  F5er's
feeds have the following URL format:

    http://hostname:port/channel_id

Where channel_id is a channel ID specified in the channel declaration.  See
the configuration section for details.

OPTIONS
-------

__--address__=hostname  
    Local host bind address. The default value is localhost.

__--port__=number  
    Local host bind port. The default value is 8080.

__--config__=file  
    Configuration file to use. The default value is /etc/f5er.conf.

__--help__  
    Print out usage information.

CONFIGURATION
-------------

Each line of the config file is either a comment or a directive.  Comment lines
start with '#' and are ignored as well as empty lines.  Directives are of two
types: channel declarations and parameter assignments.  A channel declaration
has the following format:

    [channel_id]

The only allowed characters in a channel ID are alphanumeric characters and
underscore.  All parameters following the channel declaration up to the next
declaration or up to the end of file are related to the same channel_id.  A
parameter assignment contains a parameter name and a parameter value separated
by '='.  For example:

     parameter = value

The supported parameters are listed below.

__title__  
    Required.  Defines the title of the channel.

__description__  
    Required.  Describes the channel.

__link__  
    Required.  Defines the web site URL of the channel.

__post_form__  
    Optional.  HTML form to send when fetching HTML page of the channel.  If
    set, F5er will send a POST request instead of a GET, which is the default
    method.

__selection_xpath__  
    Required.  XPath to the selection to extract.  See the
    [XPath Tutorial](#notes) for information on how to compose XPath.

__user_agent__  
    Optional.  If specified, this value will be used as _User-Agent_ header when
    downloading web pages.  If not specified, F5er will use the default value
    *Mozilla/5.0 (X11; Linux x86_64; rv:52.0) Gecko/20100101 Firefox/52.0*.

For example the following configuration may be used for monitoring current Go
version:

    [go]
    title = Go Blog
    description = The Go Programming Language Blog
    link = https://blog.golang.org/
    selection_xpath = //div[@class='article']/h3[1]

DEPENDENCIES
------------

Besides the Go compiler and the standard library, F5er requires the following
packages:

* <http://github.com/gorilla/feeds>
* <http://github.com/jaytaylor/html2text>
* <http://golang.org/x/net/html>
* <http://golang.org/x/net/html/charset>
* <http://gopkg.in/xmlpath.v2>

DOWNLOAD
--------

The latest stable version is 1.0. It's written in Go programming language. The
source code is available [here](/storage/f5er/f5er-1.0.tar.gz).

The last version written in Perl is 0.8. The source code is available
[here](/storage/f5er/f5er-0.8).

To fetch the latest source code from the git repository, run the following command:

    git clone git://vminko.org/f5er


NOTES
-----

1. [Comparison of feed aggregators](http://en.wikipedia.org/wiki/Comparison_of_feed_aggregators)
2. [XPath Tutorial](http://www.w3schools.com/xml/xpath_intro.asp)
3. [RSS Reference](http://www.w3schools.com/rss/rss_reference.asp)

HISTORY
-------

__02 Sep 2017__ - Version 1.0  
  Daemon rewritten in Go language.  The config file format and all the
  features remain the same as before.

__20 Oct 2016__ - Version 0.8  
  Added workaround for compatibility with unknown HTML tags.  
  Fixed broken link to the XPath Tutorial.

__07 Jul 2015__ - Version 0.7  
  The options `ttl` and `paginator_xpath` are no longer supported.  
  Added new option `user_agent`.

__16 Feb 2015__ - Version 0.6  
  Switched to multiprocess architecture.

__15 Mar 2014__ - Version 0.5  
  Improved configuration parser: now it detects channel redeclarations.  
  Fixed memory leak on malformed post request.

__15 Nov 2011__ - Version 0.4  
  Fixed memory leak.

__24 Oct 2011__ - Version 0.3  
  Added ability to compose channels based on POST requests (using the
  `post_form` parameter).

__10 May 2011__ - Version 0.2  
  Added cleaning up of the HTML content in order to extract nodes from pages
  with invalid markup.

__18 Apr 2011__ - Version 0.1  
  Initial public release.

COPYRIGHT AND LICENSE
---------------------

Copyright (C) 2011-2017 Vitaly Minko

This program is free software: you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation, either version 3 of the License, or (at your option) any later
version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE.  See the
[GNU General Public License](http://www.gnu.org/licenses/) for more details.

